/*
 * @(#)CapFile.java	1.1 10/08/02
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gp;

import com.sun.tck.me.tools.fs.ZipFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class CapFile extends ZipFileSystem {
    HashMap<String, String> map = new HashMap<String, String>();
    public CapFile(File cap) throws IOException {
        super(cap, cap);
        for (String path : listAllFiles()) {
            String name = path.substring(path.lastIndexOf('/') + 1);
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("More than one component:"
                        + path + ", " + map.get(name));
            }
            map.put(name, path);
        }
    }

    public InputStream getComponent(String name) throws IOException {
        String path = map.get(name);
        return (path == null) ? null : openToRead(path);
    }
}
