/*
 * @(#)SMSParser.java	1.2 10/08/24
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data.sms;

import com.sun.tck.bvtool.etsi.data.ResponsePacket;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TreeNode.Data;
import com.sun.tck.bvtool.etsi.tlv.TreeNode.Value;
import com.sun.tck.me.utils.Utils;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class SMSParser {
    public static class Phone {
        byte TP_ID;
        byte[] phone;

        public Phone(byte TP_ID, byte[] phone) {
            this.TP_ID = TP_ID;
            this.phone = phone;
        }

        @Override
        public String toString() {
            return "(type=Phone" + "TP_ID=0x" + Integer.toHexString(0xff & TP_ID)
                    + " phone=" + Utils.canonize(phone) + ')';
        }

    }

    public static Phone parseTP_DA(TLVBuffer in) throws EncodingException {
        int length = in.read();
        return new Phone((byte) in.read(),in.readArray(length / 2));
    }

    public static Object parseValidityPeriod(int header, TLVBuffer in) throws EncodingException {
        if ((header & 0x18) == 0) {
            return null;
        }
        return Long.toHexString(in.read(7));
    }

    public static void initSMS(TLV parent, byte[] data) throws EncodingException {
        TLVBuffer buff = new TLVBuffer(data);
        // 23040-681
        int header = 0xFF & data[0];
        int TP_MTI = header & 0x03;
        switch (TP_MTI) {
            case 0: // SMS-DELIVER REPORT (or SMS-DELIVER to card)
                parse_SMS_Deliver_Report(parent, buff);
                break;
            case 1: // SMS-SUBMIT (or SMS-SUBMIT-REPORT to card)
                parse_SMS_Submit(parent, buff);
                break;
            case 2: // SMS-COMMAND (or SMS-STATUS-REPORT to card)
                parse_SMS_Command(parent, buff);
                break;
            case 3: //  RESERVED
            default:
                throw new EncodingException("Unknown type: " + TP_MTI);
        }

//Description                Section M/O Min Length
// Proactive SIM command Tag  13.2    M   Y    1
// Length (A+B+C+D+E+F)         -     M   Y  1 or 2
// Command details            12.6    M   Y    A
// Device identities          12.7    M   Y    B
// Alpha identifier           12.2    O   N    C
// Address                    12.1    O   N    D
// SMS TPDU (SMS-SUBMIT or
//           SMS-COMMAND)     12.13   M   Y    E
    }
    private static void parse_SMS_Deliver_Report(TLV parent, TLVBuffer data) throws EncodingException {
        parent.add("header", new Data("header", data.read()));

    }

    private static void parse_SMS_Command(TLV parent, TLVBuffer data) {

    }

    private static void parse_SMS_Submit(TLV parent, TLVBuffer data) throws EncodingException {
        int header = data.read();
        parent.addByte("header", header);
        parent.addByte("TP-MR", data.read());
        parent.add("TP-DA", new Value("TP-DA", parseTP_DA(data)));
        parent.addByte("TP-PID", data.read());
        parent.addByte("TP-DCS", data.read());
        Object tpVp = SMSParser.parseValidityPeriod(header, data);
        if (tpVp != null) {
            parent.add("TP-VP", new Value("TP-VP", tpVp));
        }
        int length = data.read(); // parse TP-UDL
        parent.add("UDL-HEADER", new Data("UDL-HEADER", data.readArray(3)));// parse TP-UD
        ResponsePacket pack = new ResponsePacket();
        pack.setCompactMode(true);
        pack.decode(parent.getFactory(), data);
        parent.add("response", pack);
    }
}
