/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.data.SecuredPacketTLV.Header;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.RPI_TAG;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.Issuer_Security_Domain_Compact_Form;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.Issuer_Security_Domain_Expanded_Form;
/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ResponsePacket extends SecuredPacketTLV {
    ResponseScriptingTemplate response = new ResponseScriptingTemplate();
    private ArrayList<ResponseAPDU> apdus = new ArrayList<ResponseAPDU>();
    private int processedCount;

    public ResponsePacket() {
        setTagInternal(RPI_TAG, null);
    }

    public ResponsePacket(int count, ResponseAPDU apdu) {
        setTagInternal(RPI_TAG, null);
        this.apdus.add(apdu);
        header.setTAR(Issuer_Security_Domain_Compact_Form);
        processedCount = count;
    }

    public ResponsePacket(ResponseScriptingTemplate response) {
        setTagInternal(RPI_TAG, null);
        add(response);
        header.setTAR(Issuer_Security_Domain_Expanded_Form);
        this.response = response;
        this.apdus = response.getResponses();
        processedCount = response.apduCount;
        add("processed-count", new Value("processed-count", new Integer(processedCount)));
        add("response-apdus", new TreeNode.Value("response", apdus));
    }

    @Override
    public void decodeSecuredData(TLVPrototypeFactory processor,
            TLVBuffer securedData) throws Exception {
        if (securedData.available() == 0) {
            return;
        }
        header = (ResponseHeader) this.header;
        if (header.getTAR() == Issuer_Security_Domain_Compact_Form) { // compact form
            processedCount = securedData.read();
            byte[] data = new byte[securedData.available()];
            data[data.length - 2] = (byte)securedData.read(); // sw1
            data[data.length - 1] = (byte)securedData.read(); // sw2
            System.arraycopy(securedData.getBuffer(), securedData.getPos(), data, 0, data.length - 2);
            ResponseAPDU answer = new ResponseAPDU(data);
            apdus.add(answer);
        } else {
            response = new ResponseScriptingTemplate();
            response.decode(processor, securedData);
            add("response", response);
            processedCount = response.apduCount;
            apdus = response.getResponses();
        }
        add("processed-count", new Value("processed-count", new Integer(processedCount)));
        add("response-apdus", new TreeNode.Value("response", apdus));
    }

    @Override
    protected void writeSecuredData(TLVBuffer buff) throws EncodingException {
        if (header.getTAR() == Issuer_Security_Domain_Compact_Form) {
            ResponseAPDU apdu = apdus.get(0);
            buff.write(processedCount);
            buff.write(apdu.sw(), 2);
            byte[] data = apdu.getBytes();
            buff.write(data, 0, data.length - 2);
        } else {
            super.writeSecuredData(buff);
        }
    }


    public ResponseHeader getHeader() {
        return (ResponseHeader) header;
    }

    public List<ResponseAPDU> getApdus() {
        return apdus;
    }

    public ResponseScriptingTemplate getResponse() {
        return response;
    }

//    @Override
    protected Header createHeader() {
        header = (header == null) ? new ResponseHeader() : header;
        return header;
    }
}
