/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.tlv.TLV;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.CPI_TAG;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.Issuer_Security_Domain_Compact_Form;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.Issuer_Security_Domain_Expanded_Form;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class CommandPacket extends SecuredPacketTLV {

    public CommandPacket() {
        setTagInternal(CPI_TAG, "CommandPacket");
        header.setTAR(Issuer_Security_Domain_Compact_Form);
    }

    public CommandPacket(TLV tlv) {
        setTagInternal(CPI_TAG, "CommandPacket");
        add(tlv);
        header.setTAR(Issuer_Security_Domain_Expanded_Form);
    }

    @Override
    protected Header createHeader() {
        return new CommandHeader();
    }

/*
 * Table 1: Structure of the command packet
 *             Element               |  Length  | Comment
 * ----------------------------------------------------------------------------
 * Command Packet Identifier (CPI)   |  1 octet | Identifies that this data block is the secured Command Packet.
 * ----------------------------------------------------------------------------
 * Command Packet Length (CPL)       | variable | This shall indicate the number of octets from and including the
 *                                   |          | Command Header Identifier to the end of the Secured Data,
 *                                   |          | including any padding octets required for ciphering.
 * ==================Encoded by CommandHeader=========================
 * ----------------------------------------------------------------------------
 * Command Header Identifier (CHI)   | 1 octet  | Identifies the Command Header.
 * ----------------------------------------------------------------------------
 * Command Header Length (CHL)       | variable | This shall indicate the number of octets from and including the SPI
 *                                   |          | to the end of the RC/CC/DS.
 * ----------------------------------------------------------------------------
 * Security Parameter Indicator(SPI) | 2 octets | see detailed coding in clause 5.1.1.
 * ----------------------------------------------------------------------------
 * Ciphering Key Identifier (KIc)    | 1 octet  | Key and algorithm Identifier for ciphering.
 * ----------------------------------------------------------------------------
 * Key Identifier (KID)              | 1 octet  | Key and algorithm Identifier for RC/CC/DS.
 * ----------------------------------------------------------------------------
 * Toolkit Application Reference(TAR)| 3 octets | Coding is application dependent as defined in TS 101 220 [8].
 * ----------------------------------------------------------------------------
 * Counter (CNTR)                    | 5 octets | Replay detection and Sequence Integrity counter.
 * ----------------------------------------------------------------------------
 * Padding Counter (PCNTR)           | 1 octet  | This indicates the number of padding octets used for ciphering at
 *                                   |          | the end of the secured data.
 * ----------------------------------------------------------------------------
 * Redundancy Check (RC),            | variable | Length depends on the algorithm. A typical value is 8 octets if
 * Cryptographic Checksum (CC) or    |          | used, and for a DS could be 48 or more octets; the minimum
 * Digital Signature (DS)            |          | should be 4 octets.
 * ==================End Encoded by CommandHeader=========================
 * ----------------------------------------------------------------------------
 * Secured data                      | variable | Contains the Secured Application Message and possibly padding
 *                                   |          | octets used for ciphering.
 *                                   |          | Unless indicated
 * ----------------------------------------------------------------------------
 */

}
