/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.data;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import static com.sun.tck.bvtool.etsi.gsm.ETSITags.C_APDU_TAG;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class CAPDUTLV extends RawTLV {
    private CommandAPDU apdu;

    public CAPDUTLV() {
        setTagInternal(C_APDU_TAG, "C-APDU");
    }

    public CAPDUTLV(CommandAPDU apdu) {
        super(C_APDU_TAG, apdu.getBytes());
        setTagInternal(C_APDU_TAG, "C-APDU");
        this.apdu = apdu;
    }

    @Override
    public void decode(TLVPrototypeFactory processor, TLVBuffer in) throws EncodingException {
        super.decode(processor, in);
        apdu = new CommandAPDU(data);
    }

    public CommandAPDU getAPDU() {
        return apdu;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{Tag=" + getName() + ", " + apdu + "}";
    }
}
