/*
 * %W% %E%
 *
 * @Copyright
 */

package com.sun.jck.lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

import com.sun.javatest.util.StringArray;

public class MessageSwitch
{
    public MessageSwitch() throws IOException {
	this(DEFAULT_BACKLOG);
    }

    private static final int DEFAULT_BACKLOG = 5;


    public MessageSwitch(int backlog) throws IOException {
	serverSocket = new ServerSocket(0, backlog);
	listener = new Thread() {
	    public void run() {
		try {
		    listen();
		}
		catch (IOException ignore) {
		}
		finally {
		    synchronized (MessageSwitch.this) {
			listener = null;
		    }
		}
	    }
	};
	listener.setName("MessageSwitch.listener");
	listener.start();
    }

    public String getHostAndPort() throws UnknownHostException {
	InetAddress here = InetAddress.getLocalHost();
	return here.getHostName() + ":" + String.valueOf(serverSocket.getLocalPort());
    }

    public int getPort() {
	return serverSocket.getLocalPort();
    }

    private synchronized void broadcast(Task from, String[] args) {
	for (int i = 0; i < taskList.size(); i++) {
	    Task t = (Task)(taskList.elementAt(i));
	    if (t != from) 
		t.send(from, args);
	}
    }

    private synchronized void send(Task from, String taskName, String[] args) {
	for (int i = 0; i < taskList.size(); i++) {
	    Task t = (Task)(taskList.elementAt(i));
	    if (taskName.equals(t.name)) {
		t.send(from, args);
		return;
	    }
	}
	throw new IllegalArgumentException(taskName);
    }

    /*
    public synchronized void waitForClient(String name, long timeout) throws InterruptedException {
	long now = System.currentTimeMillis();
	long end = now + timeout;
	while (end > now) {
	    for (int i = 0; i < taskList.size(); i++) {
		Task t = (Task)(taskList.elementAt(i));
		if (name.equals(t.name))
		    return;
	    }
	    wait(end - now);
	    now = System.currentTimeMillis();
	}
    }
    */
    
    public synchronized void close() {
	stopping = true;
	try {
	    serverSocket.close();
	}
	catch (IOException e) {
	    handleException(e);
	}
	if (listener != null)
	    listener.interrupt();
	for (int i = 0; i < taskList.size(); i++) {
	    Task t = (Task)(taskList.elementAt(i));
	    t.stop();
	}
    }

    protected void handleException(Exception e) {
    }

    private void listen() throws IOException {
	while (!stopping) {
	    Socket s = serverSocket.accept();
	    Task t = new Task(s);
	    new Thread(t).start();
	    synchronized (this) {
		taskList.addElement(t);
		notifyAll();
	    }
	}
    }
    
    private Thread listener;
    private ServerSocket serverSocket;
    private boolean stopping;
    private Vector taskList = new Vector();

    private class Task implements Runnable {
	Task(Socket s) throws IOException {
	    socket = s;
	    in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
	    out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
	    System.err.println(I18n.getString("msgswitch.open.to",s.getInetAddress()));
	}

	public synchronized void send(Task from, String[] args) {
	    String src = (from == null || from.name == null ? "" : from.name);
	    try {
		out.writeByte(MessageClient.MESSAGE);
		out.writeUTF(src);
		out.writeShort(args.length);
		for (int i = 0; i < args.length; i++) {
		    out.writeUTF(args[i]);
		}
		out.flush();
	    }
	    catch (IOException e) {
		handleException(e);
	    }
	}

	public void stop() {
	    closeAll();
	}

	public void run() {
	    try {
		while (!stopping) {
		    int code = in.readByte();
	    System.err.println(I18n.getString("msgswitch.received", String.valueOf(code)));
		    switch (code) {
		    case MessageClient.NAME:
			synchronized (MessageSwitch.this) {
			    name = in.readUTF();
	    System.err.println(I18n.getString("msgswitch.got.name",name));
			    MessageSwitch.this.notifyAll();
			}
			break;

		    case MessageClient.BROADCAST:
			String[] bArgs = new String[in.readShort()];
			for (int i = 0; i < bArgs.length; i++) 
			    bArgs[i] = in.readUTF();
	    System.err.println(I18n.getString("msgswitch.got.broadcast",StringArray.join(bArgs)));
			broadcast(this, bArgs);
			break;

		    case MessageClient.SEND:
			String sTaskName = in.readUTF();
			String[] sArgs = new String[in.readShort()];
			for (int i = 0; i < sArgs.length; i++) 
			    sArgs[i] = in.readUTF();
	    System.err.println(I18n.getString("msgswitch.got.send", sTaskName, StringArray.join(sArgs)));
			MessageSwitch.this.send(this, sTaskName, sArgs);
			break;
		    }
		}
	    }
	    catch (IOException e) {
		handleException(e);
	    }
	    finally {
		if (name != null)
		    taskList.removeElement(name);
		closeAll();
	    }
	}

	private void closeAll() {
	    try {
		in.close();
	    }
	    catch (IOException e) {
		handleException(e);
	    }
	    
	    try {
		out.close();
	    }
	    catch (IOException e) {
		handleException(e);
	    }
	    
	    try {
		socket.close();
	    }
	    catch (IOException e) {
		handleException(e);
	    }
	}

	String name;
	Socket socket;
	DataInputStream in;
	DataOutputStream out;
    }
}
