/*
 * @(#)DistributedMultiTest.java	1.9 10/07/23
 *
 * @Copyright
 */

package com.sun.jck.lib;

import java.io.PrintWriter;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.TestCases;

public class DistributedMultiTest extends DistributedTest
{

    /**
     * Create a distributed test component.
     * @param name  	A name used to identify this component. 
     *			This is used when sending messages between 
     *			components via the message switch.
     */
    protected DistributedMultiTest(String name) {
	super(name);
    }

    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
	testCases = new TestCases(this, log);
	try {
	    testCases.exclude("go");  // exclude go() as a candidate test case
	}
	catch (TestCases.Fault e) {
	    return Status.error(I18n.getString("exclude.standard.error", "go"));
	}
	return super.run(args, log, ref);
    }

    public int decodeArg(String[] args, int index) throws Fault {
	try {
	    if (args[index].equals("-select") && index + 1 < args.length) {
		testCases.select(args[index + 1]);
		return 2;
	    }
	    else if (args[index].equals("-exclude") && index + 1 < args.length) {
		testCases.exclude(args[index + 1]);
		return 2;
	    }
	    else 
		return super.decodeArg(args, index);
	}
	catch (TestCases.Fault e) {
	    throw new Fault(e.getMessage());
	}
    }

    public Status go() {
	return testCases.invokeTestCases();
    }

    private TestCases testCases;
}
