/**
 * @(#)Logger.java	1.4 10/05/19
 * @Copyright
 */

package com.sun.javacard.referenceimpl;

import java.io.PrintWriter;
import com.sun.javacard.cjck.I18n;

public class Logger {
    public final static int DEBUG_TRACE   = 0;
    public final static int DEBUG         = 1;
    public final static int MESSAGE       = 2;
    public final static int ERROR         = 3;
    
    private PrintWriter out;
    private PrintWriter err;
    private int debug_level;
    
    public Logger(int level, PrintWriter out, PrintWriter err) {
        if ((out == null) || (err == null)) {
            throw new IllegalArgumentException(I18n.getString("null.printwriter"));
        }
        this.out = out;
        this.err = err;
        this.debug_level = level;
    }
    
    public Logger(int level, PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(I18n.getString("null.printwriter"));
        }
        this.out = out;
        this.err = out;
        this.debug_level = level;
    }
    
    void logInternal(String msg, int debug_level, PrintWriter log) {
        if (debug_level >= this.debug_level) {
            long logTime;
            long currentTime = java.lang.System.currentTimeMillis();
            logTime = currentTime; // - startTime;
            log.println(I18n.getString("log.time", Long.toString(logTime), msg));
        }
    }
    
    public void log(String msg, int debug_level) {
        logInternal(msg, debug_level, this.out);
    }
    
    public void err(String msg, int debug_level) {
        logInternal(msg, debug_level, this.err);
    }
    
    public void setDebugLevel(int level)	{
        this.debug_level = level;
        log(I18n.getString("change.debug.level", new Integer(this.debug_level), new Integer(level)),
                Logger.DEBUG);
    }
    
    /**
     * Gets verbosity level of logger
     * @returns integer value corresponding to logger verbosity level
     */
    public int getLevel()	{
        return debug_level;
    }
    
    /**
     * This method is useful to avoid unnecessary calculations before logging
     * @returns true if logger level is less or equal to Logger.DEBUG, false otherwise
     */
    public boolean isDebugEnabled() {
        return (debug_level <= Logger.DEBUG);
    }
    
    /**
     * This method is useful to avoid unnecessary calculations before logging
     * @returns true if logger level is less or equal to Logger.TRACE, false otherwise
     */
    public boolean isTraceEnabled() {
        return (debug_level == Logger.DEBUG_TRACE);
    }
    
    /**
     * This method is useful to avoid unnecessary calculations before logging
     * @returns true if logger level is less or equal to Logger.MESSAGE, false otherwise
     */
    public boolean isMessageEnabled() {
        return (debug_level <= Logger.MESSAGE);
    }
}
