/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;

/**
 * A socket-based interface to Sun's C-JCRE
 * (C language Java Card Runtime Environment).
 * <br>This is an example of a CJCKCardService which a licensee must implement.
 * <em>This code is provided as an example.  Do not assume that this code is totally correct.</em>
 * The {@link CJCKCardService} interface is the definitive specification.
 * <br>The C-JCRE is a Java Card simulator which does simulation at the byte code level.
 *
 * @version Version:1.1	Date:10/20/05
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com)
 */

public class LoadCapFileCardService extends CJCRECardService {
    
    /**
     * Creates a new C-JCRE CardService using a socket.
     * This is an example of a CJCKCardService that a licensee would implement.
     * The service cannot be used immediately. The actual initialization
     * is triggered by an invocation of <tt>initialize</tt>.
     */
    public LoadCapFileCardService() {
    }
    
    
    /**
     * Creates a new C-JCRE card service using a socket.
     */
    public LoadCapFileCardService(int port)
        throws java.io.IOException {
        super(port);
    }
    public String convertPackage(String packageName,
            AppletID packageAid,
            int majorVersion,
            int minorVersion,
            String classRootDir,
            String exportRootDir,
            boolean isExportMap,
            String outputDir,
            AppletProperties[] apa)
            throws FrameworkException {
        throw new FrameworkException("Conversion is unsupported");
    }

    /**
     * Loads the specified applets from their class files into the Proxy.
     * This method should be implemented for pre-issuance Products, which
     * support class file format.
     * <br>How the loading is done and where the applets are loaded
     * is at the discretion of the implementer.
     * <P>Note:<ul>
     * <li><em>Only the applet's package name, class name, AID, and params
     * are guaranteed to be valid.</em>
     * <li>Values of other applet properties, such as MAX_STACK, will be -1 if not specified.
     * <li>The implementer should use default values whenever a value of -1 is encountered.
     * </ul>
     * @param packageNames {@link AppletProperties} array with the
     * package names. The array contains names of the all packages,
     * which are required for the test execution.
     * @param appletProperties []an {@link AppletProperties} array
     *     which specifies the applets to be loaded.
     * @param classRootDir the root directory of the class hierarchy.
     * The path /java/lang/javacard is appended to this root,
     * yielding the directory in which the Converter will look for classes.
     * @param outputRootDir the root directory for output.
     * The Export File, if specified, must be put into the directory at
     * the outputRootDir and the path implied by the package name.
     * Any intermediate or other files produced by the Converter
     * must also go into this directory.
     * @exception DeploymentException
     *     if the Proxy is unable to load an applet in the list.
     *     The exception message should be appropriately descriptive.
     */
    public boolean loadClassFileApplets(String[] packages,
            AppletProperties[] apa,
            String classDir,
            String outputDir)
            throws DeploymentException {
        
        throw new DeploymentException(I18n.getString("loadclassfileapplet.not.applicable"));
    }
    
    
    /**
     * Loads the specified applets from their cap files into the Proxy.
     * This method should be implemented for pre-issuance Products, which
     * support CAP file format.
     * <br>How the loading is done and where the applets are loaded
     * is at the discretion of the implementer.
     * <P>Note:<ul>
     * <li><em>Only the applet's package name, class name, AID, and params
     * are guaranteed to be valid.</em>
     * <li>Values of other applet properties, such as MAX_STACK, will be -1 if not specified.
     * <li>The implementer should use default values whenever a value of -1 is encountered.
     * </ul>
     * @param capfiles {@link AppletProperties} array with the
     * cap file names. The array contains names of the all cap files,
     * which are required for the test execution.
     * @param appletProperties []an {@link AppletProperties} array
     *     which specifies the applets to be loaded.
     * @param outputRootDir the root directory for output.
     * The Export File, if specified, must be put into the directory at
     * the outputRootDir and the path implied by the package name.
     * Any intermediate or other files produced by the Converter
     * must also go into this directory.
     * @exception DeploymentException
     *     if the Proxy is unable to load an applet in the list.
     *     The exception message should be appropriately descriptive.
     */
    public boolean loadCapFileApplets(String[] capfiles,
            AppletProperties[] apa,
            String outputDir)
            throws DeploymentException {
        try {
            powerUp();
        } catch (FrameworkException ex) {
            throw new DeploymentException(ex.getMessage());
        }
        try {
            for (int i = 0; i < capfiles.length; i++) {
                log.log("Installing cap file: " + capfiles[i], Logger.MESSAGE);
                boolean current = super.installCAPFile(((i == (capfiles.length - 1)) ? apa : new AppletProperties[0]),
                                                       capfiles[i], outputDir);
                log.log("Installed cap file: " + capfiles[i] + " with " + current, Logger.MESSAGE);
                if (!current) {
                    return false;
                }
            }
            log.log("loadCapFileApplets returns true", Logger.MESSAGE);
            return true;
        } finally {
//            powerDown();
        }
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray,
            String aCAPFileName,
            String outputDir)
            throws DeploymentException {
        throw new DeploymentException("Installation is unsupported.");
    }
}
