/*
 * @(#)ServiceValidator.java	1.5 10/09/13
 * @Copyright
 */

package com.sun.javacard.globalimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.InstallMode;
import com.sun.javacard.cjck.userinterface.ValidationException;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;

/**
 * This class is used for CardService validation it should install and run
 * simple test applet on device. If test is succesful then CardService set to VERIFIED
 * state.
 *
 * COMMENT: ServiceValidator -> either CardValidator or ValidationService
 * COMMENT: Do we need a special test?
 * @author Mikhail Smirnov
 */
public class ServiceValidator {

    private static String testSuiteRoot;
    private static String workingDir;

    /**
     * Sets TestSuite root directory location that needed for validation
     * @param tsRoot
     */
    public static void setTSRoot(String tsRoot) {
        testSuiteRoot = tsRoot;//.replace(File.separatorChar, '/');
    }

    /**
     * Sets working directory location that needed for validation
     * @param wDir
     */
    public static void setWorkingDir(String wDir) {
        workingDir = wDir.replace(File.separatorChar, '/');
    }

    private static String path(String path) {
        return path.replace('/', File.separatorChar);
    }
    /*
     * FIXME: Meanwhile we use existing test for validation purposes. It should be changed to another
     * test, that isn't used for certification.
     */
    private static CardProxyArguments getCardProxyArguments() {
        return new CardProxyArguments(new String[] {
            "-Test",
            testSuiteRoot + path("/tests/check/card/TestApplet.html"),
            "-o",
            workingDir,
            "-classdir",
            testSuiteRoot + path("/classes"),
            "-exportdir",
            testSuiteRoot + path("/export_files"),
            "-bundle_size",
            "0",
            "-capfiledir",
            testSuiteRoot + path("/tests/check/card/TestApplet.html"),
            "-libdir",
            testSuiteRoot + path("/src/share/libs"),
            "-get_response_cla_byte",
            "0",
            "-executeClass",
            "com.sun.javacard.cjck.tests.check.card.TestApplet",
            "-capfile",
            "card.cap",
            "-M",
            "TestApplet.cfg",
            "-TestCount",
            "1"
        });
    }

    /**
     * Validates given instance of CardService
     * @return true if test applet is installed and passed succesfully, false otherwise
     * @throws ValidationException if some exception occured during validation
     */
    public static boolean validate(GPCardService cardService, PrintWriter logWriter, PrintWriter refWriter) throws ValidationException {
        InstallMode mode = new InstallMode();
        CardProxyArguments args = getCardProxyArguments();
        ConfigFileReader configFile = new ConfigFileReader(logWriter, refWriter);
        try {
            for (Enumeration e = args.getLibConfigFiles(); e.hasMoreElements();) {
                    configFile.read((String)e.nextElement());
            }
            configFile.read(args.getConfigFile());
            mode.init(logWriter, refWriter, cardService);
            boolean status = mode.run(args, configFile).isPassed();
            cardService.deleteInstalledPackages();
            cardService.powerDown();
            cardService.stopTest();
            return status;
        } catch (Throwable t) {
            throw new ValidationException(I18n.getString("validation.throwable", t));
        }
    }
}
