    /*
 * %W% %E%
 * @Copyright
 */
package com.sun.javacard.globalimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.BinaryToolService;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.cjck.userinterface.ValidationException;
import com.sun.javacard.referenceimpl.Logger;
import com.sun.tck.bvtool.etsi.gp.GPOverETSICardService;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * CardService implementation that works with CardTeminals via javas.smartcardio API
 *
 * @see com.sun.javacard.cjck.userinterface.BinaryToolService
 * @author Mikhail Smirnov
 */
public class GPCardService implements BinaryToolService {

    private StatefulCardTerminal terminal;
    private CJCKCardService service;
    private PrintWriter out;
    private PrintWriter ref;
    protected Logger log;
    protected Properties serviceProperties = new Properties();
    private Stack<AppletID> installedPackages = new Stack<AppletID>();
    private static final long PACKAGE_AID_LENGTH_POS = 12;

    public GPCardService() {
    }

    //mock implementation
    @Override
    public void setRealCardService(CJCKCardService service) {
        this.service = service;
    }

    @Override
    public void setCardTerminal(StatefulCardTerminal terminal) {
        this.terminal = terminal;
        if (service != null) {
            service.setCardTerminal(terminal);
        }
    }

    @Override
    public StatefulCardTerminal getCardTerminal() {
        return terminal;
    }

    @Override
    public CommunicationService getCommunicationService(int iface) throws CardProxyException {
        return service.getCommunicationService(iface);
    }

    @Override
    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputRootDir, AppletProperties[] apa) throws FrameworkException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    @Override
    public boolean deleteAppletInstances(AppletProperties[] applets) throws CardProxyException {
        return service.deleteAppletInstances(applets);
    }

    @Override
    public boolean deletePackage(AppletID packageID, String packageName) throws CardProxyException {
        boolean deleted = service.deletePackage(packageID, packageName);
        if (deleted) {
            installedPackages.remove(packageID);
        }
        return deleted;
    }

    @Override
    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws CardProxyException {
        boolean deleted = service.deletePackageAndInstances(packageID, packageName);
        if (deleted) {
            installedPackages.remove(packageID);
        }
        return deleted;
    }

    @Override
    public Hashtable getProperties() {
        return service.getProperties();
    }

    @Override
    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.out = out;
        this.ref = ref;
        service.init(args, out, ref);
        log = new Logger(0, out, ref);
    }

    @Override
    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws CardProxyException {
        boolean installed = service.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
        if (installed) {
//TODO-Logging            System.out.println("Installed CAP file:" + aCAPFileName
//TODO-Logging                    + " with AID: " + getPackageID(aCAPFileName));//FIXME: remove debug output
            installedPackages.push(getPackageID(aCAPFileName));
        }
        return installed;
    }

    @Override
    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] appletProperties, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    @Override
    public boolean loadClassFileApplets(String[] packageNames, AppletProperties[] appletProperties, String classRootDir, String outputRootDir) throws DeploymentException {
        throw new UnsupportedOperationException(I18n.getString("cardservice.unsupported.operation"));
    }

    @Override
    public void powerDown() throws CardProxyException {
        service.powerDown();
    }

    @Override
    public void powerUp() throws CardProxyException {
        service.powerUp();
    }

    @Override
    public void reset() throws CardProxyException {
        service.reset();
    }

    @Override
    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardProxyException {
        return service.sendAPDU(capdu);
    }

    @Override
    public void startTest(String workingDir, int numberOfExecutions) throws CardProxyException {
        service.startTest(workingDir, numberOfExecutions);
    }

    @Override
    public void deleteInstalledPackages() throws CardProxyException {
        reset();
        while (!installedPackages.isEmpty()) {
            //we just get an appletID from the top of the stack,
            //it is removed from installedPackages in deletePackageAndInstances() method
            AppletID aid = installedPackages.peek();
//TODO-Logging            System.out.println("deleting package with AID:" + aid); //FIXME: remove debug output
            boolean deleted = deletePackageAndInstances(aid, aid.toString());
            if (!deleted) {
                throw new FrameworkException(I18n.getString("package.deletion.failed", aid.toString()));
            }
        }
    }

    @Override
    public void stopTest() throws CardProxyException {
        service.stopTest();
    }

    @Override
    public void releaseTerminal() {
        CardServicesPool.releaseTerminal(terminal);
    }

    @Override
    public boolean validateCardService() {
//TODO-Logging        System.out.println("In validateCardService()"); //FIXME: debug output
        try {
            return ServiceValidator.validate(this, out, ref);
        } catch (ValidationException ex) {
//TODO-Logging            System.out.println("Validation fails: " + ex); //FIXME: debug output
            return false;
        }
    }

    @Override
    public boolean initializeCardService() {
//TODO-Logging        System.out.println("In initializeCardService() for " + terminal); //FIXME: debug output
        if (service != null && service instanceof GPOverETSICardService) {
            try {
                ((GPOverETSICardService) service).setCard(terminal.getInsertedCard());
            } catch (Exception e) {
                // TODO
                return false;
            }
            return true;
        } else {
            return true;
        }
    }

    @Override
    public StatefulCardTerminal.State getState() {
        return terminal.getState();
    }

    @Override
    public String getTerminalName() {
        return terminal.getLabel();
    }

    @Override
    public void setTerminalName(String name) {
        terminal.setLabel(name);
    }

    @Override
    public String toString() {
        return "GPCardService for terminal: " + terminal;
    }

    @Override
    public void setState(StatefulCardTerminal.State state) {
        terminal.setState(state);
//TODO-Logging        System.out.println("CardService state set to " + state); //FIXME: debug output
    }

    /*
     * Extracts package AID from CAP file
     */
    private static AppletID getPackageID(String capFileName) throws DeploymentException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(capFileName);
        } catch (IOException ex) {
            throw new DeploymentException(I18n.getString("no.cap.file", capFileName));
        }
        ZipEntry headerEntry = null;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().endsWith("Header.cap")) {
                headerEntry = entry;
                break;
            }
        }
        AppletID aid = null;
        InputStream in = null;
        if (headerEntry != null) {
            try {
                in = zip.getInputStream(headerEntry);
                in.skip(PACKAGE_AID_LENGTH_POS);
                int packageAidLength = in.read();
                byte[] aidBytes = new byte[packageAidLength];
                in.read(aidBytes, 0, packageAidLength);
                aid = new AppletID(aidBytes);
            } catch (IOException ex) {
                throw new DeploymentException(I18n.getString("error.reading.package.aid", capFileName));
            } finally {
                try {
                    in.close();
                } catch (IOException ioe) {
                    //ignore
                }
            }
        }
        return aid;
    }
}
