/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;
import com.sun.javacard.cjck.I18n;
import com.sun.tck.me.utils.Utils;


public class ResponseAPDU extends APDU {

    /**
     * Creates a new ResponseAPDU with the given data bytes. 
     * The given Response APDU bytes should comply with the ISO7816 standard.
     * @param data containing the response APDU bytes. 
     */
    public ResponseAPDU(byte[] data) {
        super(data);
    }

    /**
     * Returns the 2 bytes status word.
     * @return the 2 bytes status word
     */
    public int sw() {
        if ((data == null) || (data.length < 2)) {
            return -1;
        }
        return (data[data.length - 2] << 8 |
                (0xFF & data[data.length - 1])) & (0xFFFF);
    }

    /**
     * Gets the le field.
     * @return the le field.
     */
    public int getLe() {
        return (data.length < 2) ? 0 : (data.length - 2);
    }
    
    /**
     * Returns the string representation of the Response APDU.
     * @return the string representation of the Response APDU, which include the
     * the response data byte and the status word.
     */
    public String toString() {
	//* following name are ISO standard, so will keep them as is
        StringBuffer buff = new StringBuffer("Le: ");
        int Le = this.getLe();
        buff.append(byteToHex(Le));
        if (Le > 0) {
            buff.append(", Data:0x").append(Utils.canonize(data, 0, Le));
        }
//        for (int i = 0; i < Le; i++) {
//            buff.append(", ");
//            buff.append(byteToHex(data[i]));
//        }
        buff.append(" SW: ");
        buff.append(byteToHex(data[data.length - 2]));
        buff.append(byteToHexDigits(data[data.length - 1]));
    
        return buff.toString();
    }

    /**
     * Gets the ResponseAPDU data byte with the given index.
     * @param index the index of the ResponseAPDU.
     * @return the byte of the ReponseAPDU at the given index.
     */
    public int getData(int index) {
        if (!((index >= 0) && (index < getLe())))
            throw new IndexOutOfBoundsException(I18n.getString("incorrect.index", 
                                                Integer.toHexString(index), 
                                                Integer.toHexString(getLe())));
        
        return data[index] & 0xFF;
    }

    /**
     * returns the data array. This array contains only data without SW bytes.
     */
    public byte[] getResponseData() {
        byte[] retVal = new byte[data.length - 2];
        System.arraycopy(data, 0, retVal, 0, retVal.length);
        return retVal;
    }
}
