/*
 * %W% %E%
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 */

package com.sun.javacard.cjck.userinterface;


/**
 *
 * @author ms106086
 */
public class OnCardException extends RuntimeException {
    private String exceptionName;
    private int exceptionReason;
    private ResponseAPDU answer;

    public OnCardException(String name, ResponseAPDU answer) {
        this(name, 0, answer);
    }

    public OnCardException(String name, int reason, ResponseAPDU apdu) {
        super("(name=" + name + " reason=" +  reason + ")");
        this.exceptionName = name;
        this.exceptionReason = 0xFFFF & reason;
        this.answer = apdu;
    }

    public String getName() {
        return exceptionName;
    }

    public int getReason() {
        return exceptionReason;
    }

    public ResponseAPDU getAnswer() {
        return answer;
    }

    public static OnCardException create(int sw2, ResponseAPDU answer) {
        return create(sw2, 0, answer);
    }

    public static OnCardException create(int sw2, int reason, ResponseAPDU answer) {
        sw2 = 0xff & sw2;
        switch (sw2) {
            case 0x15:
            case 0x12: return new OutOfMemoryOnCardException(sw2 & 0x0f, answer);

            case 0x10: return new OnCardException("javacard.framework.SystemException", reason, answer);
            case 0x20: return new OnCardException("javacard.security.CryptoException", reason, answer);
            case 0x30: return new OnCardException("javacard.framework.APDUException", reason, answer);
            case 0xf0: return new OnCardException("java.lang.ArithmeticException", reason, answer);
            case 0xf1: return new OnCardException("java.lang.ArrayIndexOutOfBoundsException", reason, answer);
            case 0xf2: return new OnCardException("java.lang.ArrayStoreException", reason, answer);
            case 0xf3: return new OnCardException("java.lang.ClassCastException", reason, answer);
            case 0xf4: return new OnCardException("java.lang.IndexOutOfBoundsException", reason, answer);
            case 0xf5: return new OnCardException("java.lang.NegativeArraySizeException", reason, answer);
            case 0xf6: return new OnCardException("java.lang.NullPointerException", reason, answer);
            case 0xf7: return new OnCardException("java.lang.SecurityException", reason, answer);
            case 0xf8: return new OnCardException("java.lang.RuntimeException", reason, answer);
            case 0xf9: return new OnCardException("java.lang.Exception", reason, answer);
            case 0xfa: return new OnCardException("java.lang.Throwable", reason, answer);

            default:
                int newReason = sw2 & 0x0f;
                int newSw2 = sw2 & 0xf0;
                if (newReason == 0) {
                    return new OnCardException("Unknown:code=0x" + Integer.toHexString(sw2), reason, answer);
                } else {
                    return create(newSw2, newReason, answer);
                }
        }
    }
}
