/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.cjck.userinterface;

/**
 * The <code>CardProxyException</code> class.
 * The Proxy should throw a CardProxyException to raise an exception 
 * that is specific to the Proxy.  For example, 
 * <p><code><pre>
 * throw new CardProxyException("Proxy internal error");
 * </code></pre>
 *
 * @version Version:%I% Date:%G%
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com)
 */
public class CardProxyException extends CardSystemException {

    /**
     * Creates a CardProxyException with the given error message.
     * @param s the error message.
     */
    public CardProxyException(String s) {
        super(s);
    }

    public CardProxyException(String message, Throwable cause) {
        super(message, cause);
    }
}
