/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package    com.sun.javacard.cjck.userinterface;

// import com.sun.javacard.referenceimpl.*;
import com.sun.javacard.cjck.I18n;


/**
 * The factory class for all CardService classes.
 * This class is used by the CardProxyTest class;
 * <em>it is not part of the {@link CJCKCardService} interface.</em>
 *
 * @version Version:1.10 Date:10/09/03
 *
 * @author Eric Nellen (eric.nellen@eng.sun.com)
 */
public class CJCKCardServiceFactory
{
    /////////////////////////////////////////////////////////////////////////////
    // Named constants
    /////////////////////////////////////////////////////////////////////////////
   
   
    /**
     * The major version of this class, currently 2.
     */
    public final static int MAJOR_VERSION =    2;

    /**
     * The minor version of this class, currently 2.
     */
    public final static int MINOR_VERSION =    2;

    /**
     * The default CJCKCardService class.
     */
    public final static String DEFAULT_CJCK_CARD_SERVICE = "JCWDECardService";


    /**
     * Creates new CJCKCardServiceFactory.
     * @exception CardProxyException
     * thrown if unable to create a new CJCKCardServiceFactory.
     */
    public CJCKCardServiceFactory()
        throws CardProxyException {
                        
        }

    /**
     * Gets the default CardProxy.
     * @return the default CardProxy.
     * @exception CardProxyException
     * Thrown if unable to get the default CardProxy.
     */
    public static CJCKCardService getCJCKCardService()
        throws CardProxyException {
            return getCJCKCardService(DEFAULT_CJCK_CARD_SERVICE);
            
        }


    /**
     * Gets the CardProxy specified by its proxy name and class loader.
     * @param proxyClassName the class name of the CJCKCardProxy.
     * @param loader the Class loader.
     * @return the CardProxy with the given proxy name and class loader.
     * @exception CardProxyException
     * thrown if unable to get the CardProxy with the given proxy name and 
     * class loader.
     */
    public static CJCKCardService getCJCKCardService(String proxyClassName,
                                                     ClassLoader loader)
        throws CardProxyException {
        Object cs = null;
          try    {
            cs = Class.forName(proxyClassName, true, loader).newInstance();
            return (CJCKCardService)cs;
        } catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
    }
      
    /**
     * Gets the CardProxy specified by its class name.
     * @param proxyClassName the class name of the CJCKCardProxy.
     * @return CardProxy with the given proxy class name.
     * @exception CardProxyException
     * thrown if unable to get the CardProxy with the given proxy class name.
     */
    public static CJCKCardService getCJCKCardService(String proxyClassName)
        throws CardProxyException {
        CJCKCardService ccs;
        try {
            ccs = (CJCKCardService)Class.forName(proxyClassName).newInstance();
        } catch (Exception e) {
            throw new CardProxyException(I18n.getString("cardservicefactory.exception", proxyClassName, e));
        }
        return ccs;
    }

      
}  // class CJCKCardServiceFactory



