/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.userinterface;

//import javacardx.biometry.BioBuilder;

/**
 *  The intreface for the implementation dependent biometric data provider
 *  class. Each licensee is expected to implement a 
 *  <code>BiometricDataProvider</code> which will implement this interface
 *  and provide the biometric data in format used in the licencee's
 *  Biometric API implementation.
 *
 *  @author Dmitri Trounine
 */
public interface BiometricDataProvider {
/*
    public static final byte[] allBioTypes = { BioBuilder.FACIAL_FEATURE, 
            BioBuilder.VOICE_PRINT, BioBuilder.FINGERPRINT,
            BioBuilder.IRIS_SCAN, BioBuilder.RETINA_SCAN,
            BioBuilder.HAND_GEOMETRY, BioBuilder.SIGNATURE,
            BioBuilder.KEYSTROKES, BioBuilder.LIP_MOVEMENT,
            BioBuilder.THERMAL_FACE, BioBuilder.THERMAL_HAND, 
            BioBuilder.GAIT_STYLE, BioBuilder.BODY_ODOR, BioBuilder.DNA_SCAN, 
            BioBuilder.EAR_GEOMETRY, BioBuilder.FINGER_GEOMETRY,
            BioBuilder.PALM_GEOMETRY, BioBuilder.VEIN_PATTERN,
            BioBuilder.PASSWORD };
*/
    /**
     * Returns the RIDs of all on-card biometric providers. Each RID is a byte
     * array, the returned array is the array of RIDs. If there is only default
     * biometric provider, will return zero-length array.
     */
    public byte[][] getAllBiometricProvidersRIDs();
    
    /**
     * Returns the RID of the default biometric provider
     */
    public byte[] getDefaultBiometricProviderRID();
    
    /**
     * @return true if the given biometric provider supports the given bio type.
     */
    public boolean isSupportedBioType(byte bioType, byte[] RID);
    
    /**
     *  Gets the possible values of the initialization parameter for the given
     *  bio type and biometric provider. If some values are equivalent for 
     *  the OwnerBioTemplate implementation, only one of them must be present
     *  in the returned byte array. The value 0 (BioBuilder.DEFAULT_INITPARAM)
     *  should not be present.
     *
     *  @param  RID     null value means deafult provider.
     */
    public byte[] getAllInitParamValues(byte bioType, byte[] RID)
            throws NoSuchBioTypeException;
    
    /**
     * Gets all bio types supported by the given biometric provider
     */
    public byte[] getSupportedBioTypes(byte[] RID);
    
    /**
     *  Returns the byte array containing the data of a reference bio template
     *  of the given type for the given biometric provider and the given
     *  initialization parameter for the OwnerBioTemplate instance.
     *  Two successive calls to this method will return the same data.
     *
     *  @param  bioType requested bio type
     *  @param  RID     the RID of the provider of OwnerBioTemplate
     *                  implementation. null value means deafult provider.
     *  @param  initParam   the provider specific initialization information for
     *                      the OwnerBioTemplate instance. 
     *
     *  @return A byte array of positive length.
     *
     *  @exception  NoSuchBioTypeException  if the requested bio type is not
     *      supported by the given on-card biometric provider.
     */
    public byte[] getReferenceBioTemplate(byte bioType, byte[] RID,
            byte initParam) throws NoSuchBioTypeException;
    
    /**
     * Returns the byte array containing the data of a candidate bio template
     * of the given bio type for the given biometric provider, which
     * beeing matched with the reference bio template returned by the
     * <code>getReferenceBioTemplate(int, byte[])</code> method with the same
     * bioType and RID parameters, will be accepted.
     * Two successive calls to this method will return the same data.
     *
     * @param  bioType requested bio type
     * @param  RID     the RID of the provider of OwnerBioTemplate
     *                  implementation. null value means deafult provider.
     * @param  initParam   the provider specific initialization information for
     *                      the OwnerBioTemplate instance. 
     *
     * @return A byte array of positive length.
     *
     * @exception NoSuchBioTypeException    if the requested bio type is not
     *      supported by the given biometric provider.
     */
    public byte[] getPositiveCandidate(byte bioType, byte[] RID,
            byte initParam) throws NoSuchBioTypeException;

    /**
     * Returns the byte array containing the data of a candidate bio template
     * of the given bio type for the given biometric provider, which
     * beeing matched with the reference bio template returned by the
     * <code>getReferenceBioTemplate(int, byte[])</code> method with the same
     * bioType and RID parameters, will be rejected.
     * Two successive calls to this method will return the same data.
     *
     * @param  bioType requested bio type
     * @param  RID     the RID of the provider of OwnerBioTemplate
     *                  implementation. null value means deafult provider.
     * @param  initParam   the provider specific initialization information for
     *                      the OwnerBioTemplate instance. 
     *
     * @return A byte array of positive length.
     *
     * @exception NoSuchBioTypeException    if the requested bio type is not
     *      supported by the given biometric provider.
     */
    public byte[] getNegativeCandidate(byte bioType, byte[] RID,
            byte initParam) throws NoSuchBioTypeException;

    /**
     * Returns the byte array containing the data which is not a correct 
     * reference template data of the given bioType in the format supported by the
     * given biometric provider.
     *
     * @param  bioType requested bio type
     * @param  RID     the RID of the provider of OwnerBioTemplate
     *                  implementation. null value means deafult provider.
     * @param  initParam   the provider specific initialization information for
     *                      the OwnerBioTemplate instance. 
     *
     * @return A byte array of positive length or zero-length array if no such
     *          data exists.
     *
     * @exception NoSuchBioTypeException    if the requested bio type is not
     *      supported by the given biometric provider.
     */
    public byte[] getInvalidReferenceData(byte bioType, byte[] RID,
            byte initParam) throws NoSuchBioTypeException;

    /**
     * Returns the byte array containing the data which is not a correct 
     * candidate template data of the given bioType in the format supported by the
     * given biometric provider.
     *
     * @param  bioType requested bio type
     * @param  RID     the RID of the provider of OwnerBioTemplate
     *                  implementation. null value means deafult provider.
     * @param  initParam   the provider specific initialization information for
     *                      the OwnerBioTemplate instance. 
     *
     * @return A byte array of positive length or zero-length array if no such
     *          data exists.
     *
     * @exception NoSuchBioTypeException    if the requested bio type is not
     *      supported by the given biometric provider.
     */
    public byte[] getInvalidCandidateData(byte bioType, byte[] RID,
            byte initParam) throws NoSuchBioTypeException;

}
