/*
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.userinterface;

import com.sun.tck.bvtool.terminal.StatefulCardTerminal;

/**
 * BinaryToolService interface for working with card terminals
 * 
 * @author Mikhail Smirnov
 */
public interface BinaryToolService extends CJCKCardService {

    //FIXME: needed only for mock implementation
    public void setRealCardService(CJCKCardService cardService);

    /**
     * Bounds BinaryToolService instance to a terminal instance that
     * has 1-1 correspondance to physical terminal
     *
     * @param terminal
     */
    public void setCardTerminal(StatefulCardTerminal terminal);

    /**
     * Returns instance of StatefulCardTerminal class bounded
     * to this BinaryToolService instance
     *
     */
    public StatefulCardTerminal getCardTerminal();

    /**
     * Releases terminal so that other BinaryToolService instance could use it
     */
    public void releaseTerminal();


    /**
     * Deletes all packages that were installed by this service
     */
    public void deleteInstalledPackages() throws CardProxyException;


    /**
     * Performs necessary BinaryToolService initialization: e.g it requests
     * user to insert a card to a terminal and provide necessary key data to
     * communicate with the card.
     *
     * @return true if initialization was successful, false otherwise
     */
    public boolean initializeCardService();

    /**
     * Performs validation of card service, i.e. check its ability to run tests
     *
     * @return true if validation was successful, false otherwise.
     */
    public boolean validateCardService();

    /**
     * Sets state of this BinaryToolService instance
     * @param state
     */
    public void setState(StatefulCardTerminal.State state);

    /**
     * Gets state of this BinaryToolService as an integer constant
     */
    public StatefulCardTerminal.State getState();

    /**
     * Gets String label of a corresponding terminal
     */
    public String getTerminalName();

    /**
     * Sets String label for a corresponding terminal
     */
    public void setTerminalName(String name);
}
