/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts.rmi;

import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.I18n;

public class ResponseException extends ScriptFailException {

    public static final int Throwable                      = 0x00; 
    public static final int ArithmeticException            = 0x01; 
    public static final int ArrayIndexOutOfBoundsException = 0x02; 
    public static final int ArrayStoreException            = 0x03; 
    public static final int ClassCastException             = 0x04; 
    public static final int Exception                      = 0x05; 
    public static final int IndexOutOfBoundsException      = 0x06; 
    public static final int NegativeArraySizeException     = 0x07; 
    public static final int NullPointerException           = 0x08; 
    public static final int RuntimeException               = 0x09; 
    public static final int SecurityException              = 0x0A; 
    public static final int IOException                    = 0x0B; 
    public static final int RemoteException                = 0x0C; 
    public static final int APDUException                  = 0x20; 
    public static final int CardException                  = 0x21; 
    public static final int CardRuntimeException           = 0x22; 
    public static final int ISOException                   = 0x23; 
    public static final int PINException                   = 0x24; 
    public static final int SystemException                = 0x25; 
    public static final int TransactionException           = 0x26; 
    public static final int UserException                  = 0x27; 
    public static final int CryptoException                = 0x30; 
    public static final int ServiceException               = 0x40;    

    public static final int ObjectError                   = 0x0001;
    public static final int MethodError                   = 0x0002;
    public static final int ParamError                = 0x0003;
    public static final int NoResourceParam               = 0x0004;
    public static final int NoResourceResponce            = 0x0005;
    public static final int RMIProtocolError              = 0x0006;
    public static final int InternalError                 = 0xffff;

    private int type;
    private int exception_type;
    private int details;
    
    public ResponseException(int type, int exception_type, int details) {
        super(I18n.getString("error.response.type", Integer.toHexString(type), 
                             Integer.toHexString(exception_type), 
                             Integer.toHexString(details)));
        this.type = type;
        this.exception_type = exception_type;
        this.details = details;
    }
    
    public int getType() {
        return type;
    }
    
    public int getExceptionType() {
        return exception_type;
    }

    public int getDetails() {
        return details;
    }
}
