/**
 * @(#)RemoteRefWithInterfaces.java	1.8 10/05/19
 * @Copyright
 */

package com.sun.javacard.cjck.scripts.rmi;

import java.io.PrintWriter;
import java.util.Enumeration;

import com.sun.javatest.Status;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.I18n;

public class RemoteRefWithInterfaces extends RemoteRef {
    private String[][] interfaces;
    
    public RemoteRefWithInterfaces(int id, String hash, String[][] interfaces) {
        super(id, REF_WITH_INTERFACES, hash);
        this.interfaces = interfaces;
    }

    public int getInterfaceCount() {
        return interfaces.length;
    }

    public String getInterfacePackageNameString(int interfaceNumber) {
        return interfaces[interfaceNumber][0];
    }
    public String getInterfacePackageName(int interfaceNumber) {
        int pos = interfaceNumber;
        while (interfaces[pos][0].equals("") && (pos >= 0)) {
            pos--;
        }
        if (pos >= 0) {
            return interfaces[pos][0];
        } else {
            return "";
        }
    }
    
    public String getInterfaceName(int interfaceNumber) {
        return interfaces[interfaceNumber][1];
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(I18n.getString("remoterefwithclass.info.1", 
                                             Integer.toHexString(getRefID()), getHashModifier()));
        for (int i = 0; i < interfaces.length; i++) {
            buff.append(I18n.getString("remoterefwithclass.info.2", new Integer(i), 
                                        interfaces[i][0], interfaces[i][1]));
        }
        buff.append("')");
        return buff.toString();
    }

}
