/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts.rmi;

import java.io.PrintWriter;
import java.util.Enumeration;

import com.sun.javatest.Status;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.I18n;

public class RemoteRef extends Parameter {
    
    public static final int REF_UNKNOWN = 0;
    public static final int REF_NULL = 1;
    public static final int REF_WITH_CLASS = 2;
    public static final int REF_WITH_INTERFACES = 2;
    public static final int REMOTE_NULL_ID = 0xFFFF;
        
    protected int subtype;
    protected String hash_modifier;
    protected int id;

    /**
     * creates RemoteRef which encapsulates null value.
     */
    public RemoteRef() {
        super.name = I18n.getString("remote.ref");
        this.subtype = REF_NULL;
        this.id = REMOTE_NULL_ID;
    }

    public boolean isNull() {
        return this.subtype == REF_NULL;
    }

    public RemoteRef(int id, int subtype, String hash_modifier) {
        super.name = I18n.getString("remote.ref");
        this.subtype = subtype;
        this.id = id;
        this.hash_modifier = hash_modifier;
    }
    
    public int getRefID() {
        return this.id;
    }
    
    public int getSubType() {
        return this.subtype;
    }
    
    public String getHashModifier() {
        return this.hash_modifier;
    }

    public byte[] getBytes() {
        throw new IllegalArgumentException(I18n.getString("remote.re.can.not.used.as.parameter"));
    }

}
