/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javacard.cjck.I18n;

public class TLV {
    ResponseAPDU apdu;
    int offset;
    int length;
    int tag;
    
    public TLV(ResponseAPDU apdu, int offset, int tag, int length) {
        this.apdu = apdu;
        this.tag = tag;
        this.length = length;
        this.offset = offset;
    }
    
    public TLV(ResponseAPDU apdu, int offset, int totalLength)
        throws CardProxyException {
        this.apdu = apdu;
        this.tag = apdu.getData(offset++);
        this.length = apdu.getData(offset++);
        RMIScript.check(((offset + this.length) <= totalLength),
                        I18n.getString("incorrect.tlv.structure", 
                                       Integer.toHexString(tag), Integer.toHexString(length)));
        this.offset = offset;
    }
    
    public int getData(int index) {
        return apdu.getData(offset + index);
    }
    
    static TLV findTLV(int tag, ResponseAPDU apdu, int offset, int length)
        throws CardProxyException {
        try {
            
        RMIScript.debug(I18n.getString("try.find.tag.from.point", Integer.toHexString(tag), 
                                       Integer.toHexString(offset)));
        
        while (offset < length - 1) {
            TLV current = new TLV(apdu, offset, length);
            RMIScript.debug(I18n.getString("debug.rmiscript.attempt", Integer.toHexString(current.tag)));
            if (current.tag == tag) {
                return current;
            }
            offset += 2;
            offset += current.length;
        }
        return null;
        } finally {
            RMIScript.debug(I18n.getString("debug.rmiscript.done"));
        }
    }
    
    static TLV findTLV(int tag, ResponseAPDU apdu, int offset, int length,
                       String name) throws CardProxyException {
        TLV retVal = findTLV(tag, apdu, offset, length);
        RMIScript.check((retVal != null), I18n.getString("name.tag.not.found", name));
        return retVal;
    }
    
    static TLV findTLV(int tag, TLV enclosing, String name)
        throws CardProxyException {
        return findTLV(tag, enclosing.apdu, enclosing.offset,
                       (enclosing.offset + enclosing.length), name);
    }

    static TLV findTLV(int tag, TLV enclosing) throws CardProxyException {
        return findTLV(tag, enclosing.apdu, enclosing.offset,
                       (enclosing.offset + enclosing.length));
    }
}
