/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.scripts;

import java.io.PrintWriter;

import com.sun.javatest.Status;

import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.MultiTestScript;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.OnCardException;
import com.sun.javacard.cjck.userinterface.OutOfMemoryOnCardException;

public class DoTestScript extends StdScript implements MultiTestScript {
    public static final short SW_DO_TEST_PASSED = (short)0x9b00;
    public static final short SW_SELECT_PASSED  = (short)0x9000;
    private int testCount;
    private boolean[] status;
    private String executeClass;

    public DoTestScript() {
        super();
    }


    public DoTestScript(int testCount, ConfigFileReader configFile,
                        String executeClass) {
        super();
        setConfigFileReader(configFile);
        this.testCount = testCount;
        this.executeClass = executeClass;
        this.status = new boolean[testCount];
    }

    public void setArguments(String args[]) {
        for (int i = 0; i < args.length; i++) {
            if ((i + 1) < args.length) {
                if (args[i].equals("-testCount")) {
                    this.testCount = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-executeClass")) {
                    this.executeClass = args[++i];
                }
            }
        }
        this.status = (this.status == null) ? new boolean[testCount] : status;
    }


    public String getName() {
        return I18n.getString("dotest.script.count", new Integer(this.testCount));
    }


    public Status runScript() throws CardProxyException {
        log(I18n.getString("process.default.script"));
        Status retVal = Status.passed("");
        Status current;
        for (int i = 0; i < getTestCaseCount(); i++) {
            current = runTestCase(i, cardService, out, ref);
            retVal = current.isPassed() ? retVal : current;
        }
        return retVal;
    }

    public Status runTestCase(int index, CJCKCardService cardService,
                               PrintWriter out, PrintWriter ref)
        throws CardProxyException {
        init(cardService, out, ref);
        byte data[] = {
            (byte)0x80, (byte)0x20, (byte)0x00, (byte)0x00,
            (byte)0x01, (byte)0x00, (byte)0x01
        };

        if (status[index - 1]) {
            return Status.passed(I18n.getString("status.excluded"));
        }

        cardService.powerUp();
        log(I18n.getString("script.auto.generated"));
        select(executeClass, SW_SELECT_PASSED);

        try {
            data[5] = (byte)(index);
            sendAPDU(new CommandAPDU(data), SW_DO_TEST_PASSED);
        } catch (OutOfMemoryOnCardException e) {
            throw e;
        } catch (OnCardException e) {
            log("Unexpected exception during TestCase Execution:" + e);
            return Status.failed("Unexpected:" + e.getMessage());
        } finally {
            // invoke ObjectDeletion
            data[5] = (byte)0x00;
            sendAPDU(new CommandAPDU(data), SW_DO_TEST_PASSED);
            cardService.powerDown();
        }
        return Status.passed("");
    }

    public int getTestCaseCount() {
        return this.testCount;
    }

    public void setExcludeEntries(String[] entries) {
        for (int i = 0 ; i < entries.length; i++) {
            if ((entries[i].length() > 0) && Character.isDigit(entries[i].charAt(0))) {
                addExcludedNumber(parseInt(entries[i], "-exclude"));
            }
        }
    }

    private int parseInt(String value, String name) {
        try {
            return Integer.parseInt(value);
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException(I18n.getString("not.valid.integer", name, value, e));
        }
    }

    private void addExcludedNumber(int pos) {
        if ((pos < 0) || (pos > status.length))
            throw new IllegalArgumentException(I18n.getString("invalid.excluded.test", new Integer(pos)));
        status[pos - 1] = true;
    }

    private void executeDoTest(int start, int count) throws CardProxyException {
        byte data[] = new byte[6 + count];
        int pos = 0;
        data[pos++] = (byte)0x80;
        data[pos++] = (byte)0x20;
        data[pos++] = (byte)0x00;
        data[pos++] = (byte)0x00;
        data[pos++] = (byte)(count & 0xFF);
        for (int i = 1; i <= count; i++) {
            data[pos] = (byte)((status[start + i - 1]) ? 0 : (start + i));
            pos++;
        }
        data[pos] = (byte)(count & 0xFF);
        sendAPDU(new CommandAPDU(data), SW_DO_TEST_PASSED);
    }
}
