/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import java.util.Vector;
import com.sun.javacard.cjck.I18n;

public class ScriptDefinition {
    
    private String name;
    private String[] params;
    private Vector buff;
    private boolean isScriptFile;

    public ScriptDefinition(String name) {
        this.name = name;
        this.buff = new Vector();
    }
    public ScriptDefinition(String name, boolean isScriptFile) {
        this.name = name;
        this.buff = new Vector();
        this.isScriptFile = isScriptFile;
    }
    
    public ScriptDefinition(String name, String[] params) {
        this.name = name;
        this.params = params;
    }

    public boolean isScriptFile() {
        return this.isScriptFile;
    }
    
    public void addArgument(String arg) {
        if (params != null) {
            throw new IllegalArgumentException(I18n.getString("can.not.add.final.def"));
        }
        buff.addElement(arg);
    }
    
    public void addArguments(String arg1, String arg2) {
        addArgument(arg1); 
        addArgument(arg2); 
    }
    
    public String getName() {
        return name;
    }

    public String[] getParams() {
        if (params == null) {
            params = (String[])buff.toArray(new String[buff.size()]);
        }
        return params;
    }

    public JavaCardScript loadScript() throws IllegalArgumentException {
        try {
            Class cl = Class.forName(this.name);
            JavaCardScript retVal = (JavaCardScript)cl.newInstance();
            retVal.setArguments(getParams());
            return retVal;
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18n.getString("can.not.obtain.javacardscript", name));
        }
    }
}
