/*
 * %W% %E%
 *
 * @Copyright
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import java.util.Enumeration;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;

public class InstallMode extends ExecuteMode {

    public String getName() {
        return "InstallMode";
    }

    protected Status load() throws CardProxyException {
        // power up the Proxy
        log(I18n.getString("call.powerup", getName()));
        cardService.powerUp();
        Status status = null;
        // Install the all cap files
        for (Enumeration e = args.getCapFiles(); e.hasMoreElements();) {
             String name = getFullCapFileName((String)e.nextElement());

             log(I18n.getString("start.install.capfile", getName(), name));

             log(I18n.getString("call.installcapfile", getName(), name));
             ref(I18n.getString("call.installcapfile", getName(), name));
             boolean s = cardService.installCAPFile(configFile.getPropertiesByCapFile(name), name, args.getOutputDir());
             log(I18n.getString("installcapfile.return.status", getName(), Boolean.valueOf(s)));
             ref(I18n.getString("installcapfile.return.status", getName(), Boolean.valueOf(s)));
        }
        return Status.passed("");
    }
    
//    private void 
}
