/*
 * %W% %E%
 *
 * @Copyright
 */
package com.sun.javacard.cjck.invoke;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;

/**
 * This class executes the test in convert mode. In include converter 
 * invocation and verification that requested cap file is really created.
 * <p>
 * The created cap files are moved to the cap file directory specified by
 * -capfiledir option.
 */
public class ConvertMode extends RunMode {

    public String getName() {
        return "ConvertMode";
    }

    public Status run(CardProxyArguments args, ConfigFileReader configFile) 
        throws CardProxyException {
        log(I18n.getString("call.convertpackage", getName()));
        AppletProperties[] uniq;
        for (Enumeration e = configFile.getPackages(); e.hasMoreElements();) {
            String packageName = (String)e.nextElement();

            if (args.doConversion(packageName)) {

                AppletID packageAID = configFile.getPackageAID(packageName);
                String capFile;
                uniq = getUnig(configFile.getApplets(packageName));
                    
                log(I18n.getString("start.convert.package", getName(), packageName, packageAID));
                String version = configFile.getPackageVersion(packageName);
                int majorversion = args.getMajorVersion();
                int minorversion = args.getMinorVersion();
                if (version != null) {
                    majorversion = parseMajorVersion(version);
                    minorversion = parseMinorVersion(version);
                }
                capFile = cardService.convertPackage(packageName, packageAID,
                                                     majorversion, minorversion,
                                                     args.getClassDir(),
                                                     args.getExportDir(),
                                                     configFile.isExportMap(packageName),
                                                     args.getOutputDir(),
                                                     configFile.getApplets(packageName));

                log(I18n.getString("convert.create.capfile", getName(), capFile));
                if (capFile == null)
                    return Status.failed(I18n.getString("convert.return.null"));
                if (!new File(capFile).exists()) {
                    return Status.failed(I18n.getString("convert.return.nonexist.file", capFile));
                }
                storeCapFile(capFile, args.getCapFileDir());

                log(I18n.getString("back.cardproxytest.run", getName(), capFile));
            } else {
                log(I18n.getString("conversion.skipped", getName(), packageName));
            }
        }
        return Status.passed("");
    }

    private void storeCapFile(String capFileName, String path)
        throws CardProxyException {
        String base = ArgumentParser.getBasename(capFileName);
        String newName = (path == null) ? "" : path;
        File newDir = new File(newName);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        File oldDir = new File(ArgumentParser.getBasename(capFileName));
        if (!newDir.equals(oldDir)) {
            File newFile = new File (newDir + java.io.File.separator + base);
            newFile.delete();
            log(I18n.getString("movecapfile.from.to", getName(), capFileName,
                               newDir + File.separator + base));
        
            if (!(new File(capFileName)).renameTo(newFile)) {
                log(I18n.getString("can.not.move.generated.capfile", getName()));
                throw new CardProxyException(I18n.getString("exception.can.not.move.capfile"));
            } else {
                log(I18n.getString("capfile.moved", getName()));
            }
        }
    }

    private AppletProperties[] getUnig(AppletProperties[] apa) {
        Vector h = new Vector();
        Hashtable names = new Hashtable();
        if (apa == null)
            return null;
        
        for (int i = 0; i < apa.length; i++) {
            String name = apa[i].getClassName();
            if (names.get(name) == null) {
                names.put(name, "ok");
                h.addElement(apa[i]);
            }
        }
        return (AppletProperties[])h.toArray(new AppletProperties[h.size()]);
    }
    
    private static int parseMajorVersion(String version) {
        String s = version.trim();
        int pos = s.indexOf(".");
        if (pos < 1) {
            throw new IllegalArgumentException(I18n.getString("can.not.parse.version"));
        }
        return Integer.parseInt(s.substring(0, pos));
    }
    
    private static int parseMinorVersion(String version) {
        String s = version.trim();
        int pos = s.indexOf(".");
        if ((pos < 0) || (pos > (s.length() - 2))) {
            throw new IllegalArgumentException(I18n.getString("can.not.parse.version"));
        }
        return Integer.parseInt(s.substring(pos + 1));
    }
}
