/**
 * %W% %E%
 * @Copyright
 */

package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.invoke.JavaCardScript;
import com.sun.javacard.cjck.invoke.ConfigFileReader;

/**
 * This interface defines script which requires ConfigFileReader for
 * initialization. It allows to resolve applets and packages by names
 * specified in the config file.
 */
public interface ConfiguredScript extends JavaCardScript {


    /**
     * sets given ConfigFileReader for initialization.
     * This method will be invoked by CardProxyTest before script execution.
     * @param configFile given ConfigFileReader
     */
    public abstract void setConfigFileReader(ConfigFileReader configFile);


    /**
     * returns ConfigFileReader used for initialization.
     */
    public abstract ConfigFileReader getConfigFileReader();
}
