
package uicc.securechannel;

import javacard.framework.Shareable;

/**
 * This interface has to be implemented by an applet that is installed as an
 * application to application secure channel according to TS 102 484.
 *
 * The main purpose of the methods defined in this interface are to track the
 * different states of the secure channel setup between the terminal application
 * and the runtime environment of the UICC.
 * 
 */
public interface SecureChannel extends Shareable {

    /**
     * Informs the applet that a SELECT BY AID command with the AID of the applet
     * instance was received encapsulated in a TRANSACT DATA APDU by the JCRE.
     *
     * This method is mainly there for the applet to track the state of the secure
     * channel set up. After the <code>secureSelect</code> method was invoked the
     * SELCT by AID command will be handeled as a normal SELECT command according to he
     * Java Card rules and the <code>select</code> and <code>process</code> method of
     * the applet will be invoked.
     * <p>
     * Editor Note: Is that useful, sometimes I think yes it makes sense for the applet
     * to be aware of this sometimes I think that it does not bring anything.
     */
    public void secureSelect();

    /**
     * This method is called by the JCRE when it receives the command to set up the
     * Master SA. The informations for the set up of the Master SA are send to the applet.
     * One of the information is the name of he terminal application that wants
     * to set up a secure channel.
     *
     * This method provides the means to the applet to reject the secure channel set up.
     *
     * @param buffer
     * @param bOffset
     * @param bLength
     * @return true if he applet agrees to set up the secure channel
     */
    public boolean confirmSecureChannel(byte[] buffer, short bOffset, short bLength);

    /**
     * This method is invoked by the JCRE when the Secure channel between a terminal application
     * and a UICC endpoint was successfully established.
     */
    public void secureChannelEstablished();

    /**
     * This method is invoked by the JCRE if the application to application secure
     * channel is terminated according to the rules defined in the ETSI spec.
     *
     * The main purpose of this method is t provides the means to the applet
     * to track the state of the secure channel
     */
    public void terminateSecureChannel();

}
