/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

/**
 * An instance of HCIMessage is used to get access to the content of a received 
 * HCI message.
 * 
 * <P>Sub interfaces will typically have additional methods for sending HCI service
 * specific HCI messages.
 * <P>Instances of HCIMessage hide the fragmentation of messages on the HCI layer
 * (see TS 102 622). However, as receive and send buffers with limited capacity will
 * be used (size depends on the application itself) it provides methods to check if 
 * a message is complete (see isHeading() and isComplete()) in order to support 
 * streaming of long messages. 
 * (editors note: move statements about buffer sizes from getReceiveBuffer()to the previous
 * paragraph.)
 * (editor's note: check what the following sentence means:) in order to chain 
 * multiple trigger session
 * the application will need to use applicative callback for consume or produce
 * the message.
 *
 * <P>Notes:
 * <ul>
 * (editor's note: The following statement should be placed in the core specification
 * TS 102 705 and it should be reworded using standard terms (synchronous, asynchronous, ...), 
 * sha todo) 
 * <li>The HCI JavaCard API is event based: A call to methods of HCIMessage may not
 *  send or receive the data immediately during the execution of the VM.
 * It may store the relevant information and wait the exit from the JCRE in order
 * to execute the message processing as soon as possible (or prepare more data
 * to be read).
 * This avoids to have the VM suspended waiting for IO operation and to manage complex
 * re-entrence. This also permits to wait to return from an ISO context
 * (after SW emission) and avoids other IO concurrency issues.
 * (editor's note: end of part to be moved and reworded)
 * <li>Instances of this object shall be temporary JCRE entry point objects.
 * <li> The HCI framework provides a shared volatile array in order to limit application
 * memory needs. see {@link HCIMessage#getReceiveBuffer() }
 * </ul>
 * @see uicc.hci.framework.HCIListener
 **/
public interface HCIMessage {

	/* (editor's note: some/most?) of the following contants are not needed and shall
	*		be deleted, todo sha).
	**/
    // ---------  Message types -------------
    /** a command */
    public static final byte TYPE_COMMAND = (byte) 0x00;
    
    /** an event */
    public static final byte TYPE_EVENT = (byte) 0x40;
    
    /** a response*/
    public static final byte TYPE_RESPONSE = (byte) 0x80;

    // --------- All Gate Message instructions -------------
    /** The command to set a parameter in a registry */
    public static final byte INS_ANY_SET_PARAMETER = (byte) 0x01;
    
    /** The command to get a parameter from a registry */
    public static final byte INS_ANY_GET_PARAMETER = (byte) 0x02;
    
    /** The command to open a pipe */
    public static final byte INS_ANY_OPEN_PIPE = (byte) 0x03;
    
    /** The command to close a pipe */
    public static final byte INS_ANY_CLOSE_PIPE = (byte) 0x04;

    // --------- All Gate Message response -------------
    /** command completed successfully (with optional parameters)*/
    public static final byte RESP_ANY_OK = (byte) 0x00;
    
    /** the destination host is not connected*/
    public static final byte RESP_ANY_E_NOT_CONNECTED = (byte) 0x01;
    
    /** the format of the command parameters is wrong*/
    public static final byte RESP_ANY_E_CMD_PAR_UNKNOWN = (byte) 0x02;
    
    /** command was rejected and/or not completed */
    public static final byte RESP_ANY_E_NOK = (byte) 0x03;
    
    /** no more dynamic pipes can be created */
    public static final byte RESP_ADM_E_NO_PIPES_AVAILABLE = (byte) 0x04;
    
    /** the registry parameter identifier is either unknown to the registry or an optional registry parameter is not implemented*/
    public static final byte RESP_ANY_E_REG_PAR_UNKNOWN = (byte) 0x05;
    
    /** the pipe is not open */
    public static final byte RESP_ANY_E_PIPE_NOT_OPENED = (byte) 0x06;
    
    /** the command is not supported by the gate*/
    public static final byte RESP_ANY_E_CMD_NOT_SUPPORTED = (byte) 0x07;
    
    /** command is inhibited due to failure of lower layer identity check*/
    public static final byte RESP_ANY_E_INHIBITED = (byte) 0x08;
    
    /** permission denied to write/read a value to/from a registry */
    public static final byte RESP_ANY_E_REG_ACCESS_DENIED = (byte) 0x0A;
    
    /** Permission denied to create a pipe due to a WHITELIST violation*/
    public static final byte RESP_ANY_E_PIPE_ACCESS_DENIED = (byte) 0x0B;

    /**
     * editor's note: check if 'heading' is the correct term.
     */
    /** return true if the current message part is the heading part of the
     * message e.g the first part of an incoming message (and possibly the
     * last if message is complete).
     *
     * <P>Note that preparing an outgoing message (command response or event)
     * will reset the current HCI message states according the outgoing message.
     *
     * @return true if the current message is the heading part of the message
     * e.g the first part of an incoming message.
     **/
    public boolean isHeading();

    /** return true if the message is complete.
     * 
     * editor's note: clarify the meaning of the following sentence:
     * 
     * This method may be used for incoming messages in order to anticipate a call to the
     *
     * <P>Please note that preparing an outgoing message (command response or event)
     * will reset the current HCI message states according the outgoing message.
     *
     * @return true if the message is complete
     **/
    public boolean isComplete();

    /** return the message type (b8-b7 of the message header)
     * 
     * editor's note: check if this method is still needed.
     * 
     * <ul>
     * <li>TYPE_COMMAND
     * <li>TYPE_EVENT
     * <li>TYPE_RESPONSE
     * </ul>
     * <P>Please note that in the case of a fragmented incoming message the type
     * is keep in memory even if the data processed is no more in the first heading
     * packet.
     * @return return the message type.
     **/
    public byte getType();

    /** 
     * editor's note: check if needed and reword or delete accordingly).
     * returns the message instruction (b6-b1 of the message header).
     * depending on the message type the instruction specifies a commands, an event or
     * a response code between 0x00 and 0x3F.
     *
     * <P>Please note that in the case of a fragmented incoming message the instruction
     * is kept in memory even if the data processed is no more in the first heading
     * packet.
     * <P>Please note that preparing an outgoing message (command response or event)
     * will reset the current HCI message states according to the outgoing message.

     * @return return the message instruction
     **/
    public byte getInstruction();

    /** return the underlying receive message buffer.
     * <P>When the listener is triggered with an incoming message the usable data
     * may be found at {@link #getReceiveOffset()} offset up to  {@link  #getReceiveLength() }
     * length.
     * Notes:
     * <ul>
     * <li>The framework will write the received HCI message to the offset
     * given by {@link #getReceiveOffset() }
     * <li>The framework will copy data in the receive buffer up to its length.
     * When this length is exceeded the HCIMessage will be set as not complete.
     * (in other words when the message is incomplete the receive buffer must be
     * full)
     * <li> The application may use the whole receive buffer for
     * its internal purposes, even before the offset returned by {@link #getReceiveOffset()}
     * and after the length given by {@link  #getReceiveLength()}. For example it
     * may use it as working buffer when preparing an output message.
     * <li>The framework implementation shall guarantee a buffer size
     * to receive a message of 270 bytes of data.
     * (so the {@link #getReceiveOffset()} offset include).
     * <li>The content of this array is not guaranteed between several invocations. 
     * <li> The content of the buffer is not cleared between triggering session
     * (even before triggering an other application) if the buffer is used for
     * manipulation of sensitive data it shall be cleared by the application before 
     * returning to the JCRE.  
     * </ul>
     * @return return the message receive buffer.
     **/
    public byte[] getReceiveBuffer();

    /** 
     * This method returns the offset to the received message data in the receive buffer.
     * @return the receive message data offset.
     **/
    public short getReceiveOffset();

    /** This method returns the length of the received message data. If the message is 
     * not complete then the returned value is the actual fragment length.
     * <P>This methods may be used to detect how many bytes are available for processing
     * in the receive buffer.
     * <P>Note: The data will be considered as consumed when the Applet 
     * returns from the callback method even when the data were not accessed. 
     * @return the message data length available in the receive buffer.
     * @see #isComplete() 
     **/
    public short getReceiveLength();

}
/******************************************************************************
 * $log: $
 ******************************************************************************/
