/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.Shareable;

/** The tagging interface for all types of HCI listeners.
 * <P> An <code>HCIListener</code> interface has to be implemented by an Applet 
 * which wants to interact with an <code>HCIService</code>.
 * <P> Each sub interfaces of this interface shall implement a method to process incoming 
 * messages to process HCI messages. 
 * These methods may also support an internal callback triggering requested by the
 * application itself.
 *
 * @see uicc.hci.framework.HCIService
 * @see uicc.hci.framework.HCIMessage
 **/
public interface HCIListener extends Shareable {

    // --------------- triggering values --------------------
    /** this value must be used as return by an HCIListener when it no more
     * want to be call back for an internal process (e.g do not want to initiate
     * more output...) whereas defined values in each HCIListener sub-interfaces 
     * for related conditions will trigger a call back.
     */
    public final static short TRIG_NO_MORE_PROCESS = (short) 0x0000;

    /** This method is called by the HCI framework in 3 situations:
     * 1. A predefined condition (see HCIService.activateEvent()) is fulfilled. 
     * 
     * 2. A certain return value on a previous invocation of this method was returned. 
     * 
     * 3. When a previous call to the method HCIService.requestCallBackNotification() from the
     * same Applet was made.
     * 
     * (editor's note: 
     *  1. align all methods with the word fragment 'triggering'.
     *  2. improve wording )
     *
     * 
     * @param  event the condition caused this invocation of onCallBack()
     * @param message the HCIMessage
     * @return condition for next invocation:
     * <ul>
     * <li>{@link uicc.hci.framework.HCIListener#TRIG_NO_MORE_PROCESS}: the listener does
     *  not request to be called back
     * <li> value greater than 0: The listener request to be call back as soon
     * as possible with the given triggering condition. The specific values are 
     * listed in the documentation of the sub interfaces.
     * <li> value less than  0: forbidden (will be ignored).
     * </ul>
     */
    public byte onCallBack(byte event, HCIMessage message);

}

