/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIService;

/** 
 * Service which enables Contactless Reader functionality.
 **/
public interface ReaderService extends HCIService {
    
    // ------------ Type --------------------
    /** ISO/IEC 14443 Type B reader RF */
    public final static byte TYPE_B_READER_RF = 0x11;
    
    /** ISO/IEC 14443 Type A reader RF */
    public final static byte TYPE_A_READER_RF = 0x12;

 
    /** 
     * This method returns the RF technology which the card is using,
     * that was discovered by the CLF.
     * 
     * @return the reader RF type on which the service is connected shall be one of the
     *         constant TYPE_* constant values defined in this interface, or -1 if the RF
     *         type can not be evaluated.
     */
    public byte getReaderRFType();
}
