/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.cltobserver;

import uicc.hci.framework.HCIListener;

/**
 * The instance of an Applet which implements the interface <code>CltObserverListener</code>
 * can receive notifications through the <code>onCallback</code> method of this interface.
 * The <code>HCIMessage</code> reference passed through the <code>onCallback</code>
 * method of this interface shall be of type <code>CardEmulationMessage<code>.
 *
 * The Contactless Framework shall invoke the method <code>CLTObserverListener.onCallback()</code>
 * only with event(s) which are defined in <code>CLTObserListener</code>. At this time
 * only the event <code>EVENT_CLT_TRANSACTION_A<code> is defined. Notifications about CLT mode
 * transactions for type F are FFS.
 *
 * The Applet instance must activate the event(s) with <code>CLTObserverService.activateEvent()</code>
 * before it will receive any event notification.
 *
 * @see CardEmulationMessage
 * @see CLTObserverService
 **/
public interface CLTObserverListener extends HCIListener{
    
    /**
     * This value is used to notify the Applet when an EVT_FIELD_OFF event
     * has been received on an HCI pipe connected a Contactless Card Emulation
     * gate and data were exchanged in CLT mode using RF type A immediately
     * before.
     * This event shall only be notified when the UICC is in Full Power mode.
     * The CardEmulationMessage object passed to
     * <code>CLTObserverListener.onCallback(EVENT_CLT_TRANSACTION_A, message)<code>
     * corresponds to the HCI event EVT_FIELD_OFF.
     */
    public final static byte EVENT_CLT_TRANSACTION_A_DONE = 0x61;
    
    
}
