
package uicc.securechannel;

import javacard.security.*;

/**
 * This class acts as the entry point to the secure channel runtime environment
 * extensions of the CAT runtime environment.
 *
 * It allows to register secure channel applets.
 * 
 */
public final class SecureChannelSystem {

    /**
     * A method to retrieve the type of secure channel that are supported for the 
     * APDU protocol
     */
    public static boolean isSecureChannelSupported(short typeOfSC){
        return false;
    }

    /**
     * The informations needed to set up a GBA based secure channel are already
     * deployed to the UICC. There is no need for the applet to register additional
     * information.
     *
     * Exception: UICC does not support GBA, UICC does not support secure channel at all
     */
    public static void registerGBAendpoint() {
        return;
    }

    /**
     * A possible registration for an endpoint where the applet supplies the MS and indication of the algortihms to be used
     *
     * Editors Note: That needs more work
     */
    public static void registerEndpoint(boolean weak,Key masterSecret,short cipher_indication,short integrity_indication){
        return;
    }
}
