package uicc.scws;

import javacard.framework.CardRuntimeException;

/**
 * Smart Card Webserver exception and its associated constants.
 */
public class ScwsException extends CardRuntimeException
{

    /**
     * This reason code (= 1) is used to indicate that the Http response was already sent
     * to the SCWS
     */
    public final static short HTTP_RESPONSE_ALREADY_SENT = (short) 1;

    /**
     * This reason code (= 2) is used to indicate an overflow of the Response Buffer.
     */
    public static final short BUFFER_OVERFLOW = (short) 2;

    /**
     * This reason code (= 3) indicates that the HTTP method is not supported by the
     * <code>ScwsExtension</code> applet.
     */
    public static final short METHOD_NOT_SUPPORTED = 3;

    /**
     * This reason code (= 4) indicates that the header of the HTTP response was already
     * finalized.
     */
    public static final short HEADER_ALREADY_FINALIZED = 4;
    /**
     * This reason code (= 5) indicates an error in the SCWSExtension registry 
     */
    public static final short SCWSEXTENSION_REGISTRY_ERROR = 5;

    /**
     * This reason code (= 6) is used to indicate that the requested offset	 
     * could not be reached.
     */
    public static final short UNREACHABLE_OFFSET = (short) 6;
     /**
      * This reason code (= 7) is used to indicate that an unknown keywordID was used
      */
     public static final short UNKNOWN_KEYWORD_ID = (short)7;
     /**
     * This reason code (= 8) is used to indicate that the status line has already been written by the SCWS
     */
    public static final short STATUS_LINE_ALREADY_SET = (short) 8;
     /**
      * This reason code (= 9) is used to indicate that the indicated status code is unknown
      */
     public static final short HTTP_CODE_UNKNOWN = (short)9;



    public ScwsException(short arg0)
    {
        super(arg0);
    }

    /**
     * Throws the JCRE instance of ScwsException with the specified reason.
     *
     * @param reason the reason for this exception
     * @exception ScwsException always
     */
    public static void throwIt(short reason) throws ScwsException
    {
    }
}
