/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.oracle.javacard.themeapp;

import javacard.framework.*;
/**
 *
 * @author Volker Bauche
 */
public final class ThemeApplet1 extends Applet {

    /* constants declaration */

    // code of CLA byte in the command APDU header
    final static byte Theme_CLA = (byte) 0x90;

    // codes of INS byte in the command APDU header
    final static byte INIT_READ_THEME  = (byte) 0x10;
    final static byte INIT_WRITE_THEME = (byte) 0x11;
    final static byte FETCH = (byte) 0x12;
    final static byte WRITE = (byte) 0x13;
    // final static byte INIT  = (byte) 0x14;

    final static short MEMORY_SIZE = (short)26000;   // would be nice to make to deliver the array size in the Init APDU

    final static short THEMA_ALLREADY_ALLOCATED = (short)0x6FAA;

    final static byte LOGICAL_CHAN_MASK = (byte)0xFC;

    /**
     * The Theme as a byte array. Not static gives us the possiblity to have several instances of the same Applet
     */
    private byte[] theme = null;
    private short writePointer;
    private short readPointer;

    /**
     * Installs this applet.
     *
     * @param bArray
     *            the array containing installation parameters
     * @param bOffset
     *            the starting offset in bArray
     * @param bLength
     *            the length in bytes of the parameter data in bArray
     */
    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new ThemeApplet1();
    }

    /**
     * Only this class's install method should create the applet object.
     */
    protected ThemeApplet1() {
        //theme = new byte[MEMORY_SIZE];
        this.writePointer = 0;
        this.readPointer = 0;
        register();
    }

    /**
     * Processes an incoming APDU.
     *
     * @see APDU
     * @param apdu
     *            the incoming APDU
     */
    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        // check SELECT APDU command

        /*
        if (apdu.isISOInterindustryCLA()) {
            if (buffer[ISO7816.OFFSET_INS] == (byte) (0xA4)) {
                return;
            }
            ISOException.throwIt(ISO7816.SW_CLA_NOT_SUPPORTED);
        }
        */
        if (buffer[ISO7816.OFFSET_INS] == (byte) (0xA4)) {
                return;
        }

        // verify the rest of commands have the
        // correct CLA byte, which specifies the
        // command structure
        
        if ((buffer[ISO7816.OFFSET_CLA]&LOGICAL_CHAN_MASK) != Theme_CLA) {            // Achtung logical channels muss noch gefixt werden
            ISOException.throwIt(ISO7816.SW_CLA_NOT_SUPPORTED);
        }
        

        switch (buffer[ISO7816.OFFSET_INS]) {
            case INIT_READ_THEME:
                initReadTheme(apdu);
                return;
            case INIT_WRITE_THEME:
                initWriteTheme(apdu);
                return;
            case FETCH:
                fetch(apdu);
                return;
            case WRITE:
                write(apdu);
                return;
//             case INIT:
//                 if(theme == null) {
// 	           this.theme = new byte[MEMORY_SIZE];
//                 } else {
//                     ISOException.throwIt((short)0x6FAA);
//                 }
//                 return;
            default:
                ISOException.throwIt(ISO7816.SW_INS_NOT_SUPPORTED);
        }

    } // end of process method

    private void initReadTheme(APDU apdu) {

        byte[] buffer = apdu.getBuffer();

        byte numBytes = (buffer[ISO7816.OFFSET_LC]);

        byte byteRead = (byte) (apdu.setIncomingAndReceive());

        if ((numBytes != 1) || (byteRead != 1)) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        // get theme ID
        byte themeID = buffer[ISO7816.OFFSET_CDATA];

        // reset read Pointer
        readPointer = 0;

        // inform system that the applet has finished
        // processing the command and the system should
        // now prepare to construct a response APDU
        // which contains data field
        short le = apdu.setOutgoing();

        if (le < 3) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        // informs the CAD the actual number of bytes
        // returned
        apdu.setOutgoingLength((byte) 3);


        // move the length of theme array into the APDU buffer
        // starting at the offset 0
        try {
            buffer[0] = (byte) 0x06;
            buffer[1] = (byte) (writePointer >> 8);
            buffer[2] = (byte) (writePointer & 0xFF);
            /*
            for (short i = 0; i < 4; ++i) {
                short shift = i << 3; // i * 8
                buffer[4-i] = (byte)((writePointer & (0xff << shift)) >>> shift);
            }
             */

        } catch(Exception e) {
            ISOException.throwIt((short)0x6F88);
        }

        // send the value of write pointer at the offset
        // 0 in the apdu buffer
        apdu.sendBytes((short) 0, (short)3);

    } // end of initReadTheme method

    private void initWriteTheme(APDU apdu) {

        this.theme = new byte[MEMORY_SIZE];

        byte[] buffer = apdu.getBuffer();

        byte numBytes = (buffer[ISO7816.OFFSET_LC]);

        byte byteRead = (byte) (apdu.setIncomingAndReceive());

        if ((numBytes != 1) || (byteRead != 1)) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        // get theme ID
        byte themeID = buffer[ISO7816.OFFSET_CDATA];

        // reset read and write Pointer
        readPointer = 0;
        writePointer = 0;

    } // end of initWriteTheme method

    private void fetch(APDU apdu) {

        byte[] buffer = apdu.getBuffer();

        byte numBytes = (buffer[ISO7816.OFFSET_LC]);

        byte byteRead = (byte) (apdu.setIncomingAndReceive());

        if ((numBytes != 4) || (byteRead != 4)) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        short from = Util.getShort(buffer, ISO7816.OFFSET_CDATA);
        short to = Util.getShort(buffer, (short)(ISO7816.OFFSET_CDATA + 2));

        // inform system that the applet has finished
        // processing the command and the system should
        // now prepare to construct a response APDU
        // which contains data field
        short le = apdu.setOutgoing();

        short bytesToBeSent = (short)(to - from);

        if (le < bytesToBeSent) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        // informs the CAD the actual number of bytes
        // returned
        apdu.setOutgoingLength((byte) bytesToBeSent);

        // set read pointer
        readPointer += bytesToBeSent;

        // move the bytes of requested chunk into the APDU buffer
        // starting at the offset 0

        for(short i=from; i< to; i++) {
            buffer[(short)(i-from)] = theme[(short)i];
        }

        // send the number of bytes read at the offset
        // 0 in the apdu buffer
        apdu.sendBytes((short) 0, bytesToBeSent);

    } // end of fetch method

    private void write(APDU apdu) {

        byte[] buffer = apdu.getBuffer();

        byte numBytes = (buffer[ISO7816.OFFSET_LC]);
        // System.out.println("Lc = " + numBytes);

        byte bytesRead = (byte) (apdu.setIncomingAndReceive());

        if (numBytes != bytesRead) {
            ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);
        }

        for(short i=0; i<bytesRead; i++) {
            // if((i%16) == 15) {
            //     System.out.println(buffer[ISO7816.OFFSET_CDATA + i] + " ");
            // } else {
            //     System.out.print(buffer[ISO7816.OFFSET_CDATA + i] + " ");
            // }
            theme[(short)(writePointer + i)] =
                    buffer[(short)(ISO7816.OFFSET_CDATA + i)];
        }

        // set writePointer
        writePointer += bytesRead;
        /*
        if(bytesRead < 16) {
            System.out.println("");
            System.out.println("Theme length: " + writePointer);
            for(short i=0; i<16; i++) {
                System.out.print(theme[i] + " ");
            }
            System.out.println("...");
            System.out.print("... ");
            for(short i=writePointer -16; i<writePointer; i++) {
                System.out.print(theme[i] + " ");
            }
            System.out.println("");
        }
        */

    } // end of write method

    /*
    public static final int getInt(byte[] bArray, short bOff) throws NullPointerException,
            ArrayIndexOutOfBoundsException {
        int number = 0;
        for (int i = 0; i < 4; ++i) {
            number |= (bArray[bOff + 3-i] & 0xff) << (i << 3);
        }
        return number;
    }
    */
}
