/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIService;

/** 
 * Service which provides Contactless card emulation functionality.
 * 
 * Note: Contactless applications which do not use the services provided by the uicc.hci
 * packages will be invoked with process().
 **/
public interface CardEmulationService extends HCIService {

    // ------------ events --------------------
	/**
	 * editor's note: the following constants are to be deleted because
	 * appropriate constants are already defined in CardEmulationListener.
	 */


    // ------------ card RF type --------------------
    /** Type B reader RF */
    public final static byte TYPE_B_CARD_RF = (byte) 0x21;
    /** Type B' reader RF */
    public final static byte TYPE_B_PRIM_CARD_RF = (byte) 0x22;
    /** Type A reader RF */
    public final static byte TYPE_A_CARD_RF = (byte) 0x23;
    /** Type F card RF */
    public final static byte TYPE_F_CARD_RF = (byte) 0x24;

    /*
     * editor's note: all type a, b, b' and f parameter were moved to CardEmulationMessage
     */
 

    /** return the card RF type on which the service is connected.
     * <P>Value may be:
     * <ul>
     * <li>TYPE_B_CARD_RF
     * <li>TYPE_B_PRIM_CARD_RF
     * <li>TYPE_A_CARD_RF
     * <li>TYPE_F_CARD_RF
     * </ul>
     * @return the reader RF type on which the service is connected.
     */
    public byte getCardRFType();
}
