/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.CardRuntimeException;

/**
 * Exception class for the HCI packages, and instance of this Exception is owned by the JCRE.
 * (editor's note: sha to align wording with TS 102 241)
 **/
public class HCIException extends CardRuntimeException {

    // ---------  Reasons value -------------
    /** The HCI resource is not available. */
    public final static short HCI_NOT_AVAILABLE = 0x0000;
    
    /** The caller context is not granted access to this HCI resource*/
    public final static short HCI_ACCESS_NOT_GRANTED = 0x0001;
    
    /** Indicates that an attempt to send a command was made before the 
     * responses to the previous command were received.
     * (editor's note: better wording needed, eventually rename reason code. */
    public final static short INTERLEAVE_MESSAGE_DURING_PENDING_CMD = 0x0002;
    
    /** Listener could not be registered because it is already set to another 
     * Applet or used by the system itself. 
     * (editor's note: check in which context this reason code is used an reword eventually.)
     */
    public final static short SYSTEM_SERVICE_RESERVED = 0x0003;
    
    /**
     * Construct an HCIException with a reason code. To save resources use the
     * <code>throwIt()</code> method to re-use the JCRE instance of this class.
     * (editor's note: sha to align wording with tS 102 241)
     * @param  reason the error reason
     */
    public HCIException(short reason) {
        super(reason);
    }

    /**
     * Throws the JCRE owned instance of the <code>HCIException</code> with the specified
     * reason code.
     * 
     * @param reason the reason for the exception.
     * @exception HCIException
     */
    public static void throwIt(short reason) throws HCIException {
    }
}
/******************************************************************************
 * $log: $
 ******************************************************************************/
