package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIListener;

/**
 * The instance of an Applet which implements the interface <code>CardEmulationListener</code> 
 * can receive events through the <code>onCallback</code> method of this interface and can process 
 * <code>CardEmulationMessage</code> objects passed through the <code>onCallback</code> method of this interface. 
 * 
 * The Contactless Framework shall invoke the method <code>CardEmulationListener.onCallback</code> only with 
 * events which are defined in <code>CardEmulationListener</code> or <code>HCIListener</code> 
 * and only with <code>CardEmulationMessage</code> objects. 
 * 
 * The Applet instance must activate the events with <code>CardEmulationService.activateEvent</code> 
 * before it will receive any event notification.
 * 
 * @see CardEmulationService
 * @see CardEmulationMessage
 **/
public interface CardEmulationListener extends HCIListener {

    /** This value is used to notify the Applet when a response to the 
     * {@link CardEmulationMessage#prepareAndSendGetParameterCommmand(byte)}
     * is received.
     *
     */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /** This value is used to notify the Applet when the HCI event EVT_SEND_DATA
     * is received.
     */
    public final static byte EVENT_ON_SEND_DATA = (byte) 0x50;

    /** This value is used to notify the Applet when the HCI event EVT_FIELD_OFF
     * is received
     */
    public final static byte EVENT_FIELD_OFF = (byte) 0x54;
}

