/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIListener;

/** 
 * The instance of an Applet which implements the interface <code>ReaderListener</code> 
 * can receive events through the <code>onCallback</code> method of this interface and can process 
 * <code>ReaderMessage</code> objects passed through the <code>onCallback</code> method of this interface. 
 * 
 * The Contactless Framework shall invoke the method <code>ReaderListener.onCallback</code> only with 
 * events which are defined in <code>ReaderListener</code> or <code>HCIListener</code> 
 * and only with <code>ReaderMessage</code> objects. 
 * 
 * The Applet instance must activate the events with <code>ReaderService.activateEvent</code> 
 * before it will receive any event notification.
 * 
 * @see ReaderService
 * @see ReaderMessage
 **/

public interface ReaderListener extends HCIListener {

    /**
     * This value is used to notify the Applet when a response to the
     * {@link ReaderMessage#prepareAndSendGetParameterCommand(byte)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /**
     * This value is used to notify the Applet when a response to the
     * {@link ReaderMessage#prepareAndSendWriteXchgDataCommand(byte, byte[], short, short)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     */
    public final static byte EVENT_WRITE_EXCHANGE_DATA_RESPONSE = (byte) 0x02;

    /**
     * This value is used to notify the Applet when the HCI event EVT_TARGET_DISCOVERD
     * as received from the CLF.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_TARGET_DISCOVERED = (byte) 0x50;
}