
package uicc.hci.services.connectivity;

import uicc.hci.framework.HCIListener;

/** 
 * The instance of an Applet which implements the interface <code>ConnectivityListener</code> 
 * can receive events through the <code>onCallback</code> method of this interface and can process 
 * <code>ConnectivityMessage</code> objects passed through the <code>onCallback</code> method of this interface. 
 * 
 * The Contactless Framework shall invoke the method <code>ConnectivityListener.onCallback</code> only with 
 * events which are defined in <code>ConnectivityListener</code> or <code>HCIListener</code> 
 * and only with <code>ConnectivityMessage</code> objects. 
 * 
 * The Applet instance must activate the events with <code>ConnectivityService.activateEvent</code> 
 * before it will receive any event notification.
 * 
 * @see ConnectivityService
 * @see ConnectivityMessage
 **/
public interface ConnectivityListener extends HCIListener {

    
    /** 
     * This value is used to notify the Applet when the HCI event 
     * EVT_STAND_BY is received.
     */
    public final static byte EVENT_STAND_BY = (byte) 0x50;
}
