package uicc.connection;

/**
 * This interface defines event constants that are used for notifications of state changes of connections represented
 * by SCP81Connection:
 * connection established (corresponds to successful open())
 * connection setup failed (corresponds to unsuccessful open())
 * connection closed (corresponds to successful close())
 * communication error (corresponds to unexpected communication breakdown)
 * server switch to other application (corresponds to server selecting another application via Content-Type header field)
 * The object implementing <code>SCP81ConnectionStatus</code> interface is a <b>Temporary Entry Point Object</b>.
 */

public interface SCP81ConnectionStatus extends Event
{
    /** This constant is used if the connection was successfully opened.. */
    public static final short CONNECTION_ESTABLISHED  = (short) 0x0001 ;

    /** This constant is used if the connection could not been opened. */
    public static final short CONNECTION_SETUP_FAILED  = (short) 0x0002 ;

    /** This constant is used if connection was closed due to a communication error. */
    public static final short COMMUNICATION_ERROR = (short) 0x0003 ;

    /** This constant is used if connection was closed due an invocation of SCP81Connection.close(). */
    public static final short CONNECTION_CLOSED = (short) 0x0004 ;

    /** This constant is used if connection server switched to another application via Content-Type header field */
    public static final short SERVER_SWITCH = (short) 0x0005 ;


    /**
     * Used to retrieve detailed information about the state change..
     * @return the reason for closing this connection.
     */
    public short getDetails();
}

