package uicc.connection;

/**
 * Notification about closing of a reliable link.
 * It can notify only a <code>UICCTransportLink</code> object.
 *
 * The object implementing <code>UICCTransportLinkDisconnected</code>
 * interface is a <b>Temporary Entry Point Object</b>.
 *
 * <br>The <code>UICCTransportLinkDisconnected</code> is only used if the
 * reliable link has already been connected.
 *
 */
public interface UICCTransportLinkDisconnected extends Event
{
    /**
     * Used to retrieve the reason for closing the reliable
     * link (e.g. for CAT_TP the value which is provided in the RST-PDU).
     *
     * @return the reason for closing of this reliable link.
     */
    public short getReason();
}
