package uicc.connection;

/**
 * This event notifies a <code>UICCTransportLink</code> or <code>BIPLink</code> about data reception.
 *
 * The object implementing <code>DataReceived</code>
 * interface is a <b>Temporary Entry Point Object</b>.
 *
 */
public interface DataReceived extends Event
{

    /**
     * Returns the amount of data received
     */
    public int getReceivedDataLength();

    /**
     * Copy the received data in a buffer.
     *
     * @param srcOffset the offset of the first byte to copy in the received data
     * @param dstBuffer a reference to the destination buffer
     * @param dstOffset the position in the destination buffer
     * @param dstLength the data length to be copied
     * @return <code>dstOffset+dstLength</code>
     *
     * @exception  NullPointerException if <code>dstBuffer</code> is <code>null</code>
     *
     * @exception  ArrayIndexOutOfBoundsException  if <code>dstOffset</code>
     * or <code>dstLength</code> or both would cause access outside array bounds,
     * or if <code>dstLength</code> is negative.
     *
     * @exception ConnectionException with the following reason code:
     *         <ul>
     *              <li><code>OUT_OF_DATA_BOUNDARIES</code> if <code>srcOffset</code>
     *                    or <code>dstOffset</code> or <code>dstLength</code> would cause
     *                    access outside received data.
     *          </ul>
    * @exception NullPointerException if <code>dstBuffer</code> is equal to <code>null</code>
     *
     */
    public short copyReceivedData(int srcOffset, byte[] dstBuffer, short dstOffset, short dstLength);


}

