/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.connectivity;

import uicc.hci.framework.HCIListener;

/** 
 * An instance implementing ConnectivityListener is used by an Applet
 * to monitor the ConnectivityService.
 * 
 * @see ConnectivityService
 **/
public interface ConnectivityListener extends HCIListener {

    
    /** 
     * This value is used to notify the Applet when the HCI event 
     * EVT_STAND_BY is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     */
    public final static byte EVENT_STAND_BY = (byte) 0x50;


    /**    
     * This method is called by the HCI framework in 3 situations:
     * 1. A predefined condition (see HCIService.activateEvent()) is fulfilled. 
     * 
     * 2. A certain return value on a previous invocation of this method was returned. 
     * 
     * 3. When a previous call to the method HCIService.requestCallBackNotification()from the
     * same Applet was made.
     * 
     *  2. improve wording )
     *
     * 
     * @param  event the condition caused this invocation of this method
     * @param message the HCIMessage
     * @return condition for next invocation:
     * <ul>
     * <li>{@link uicc.hci.framework.HCIListener#TRIG_NO_MORE_PROCESS}: the listener does
     *  not request to be called back
     * <li> value greater than 0: The listener request to be call back as soon
     * as possible with the given triggering condition. The specific values are 
     * listed in the documentation of the sub interfaces.
     * <li> value less than  0: forbidden (will be ignored).
     * </ul>     
     */
    //public byte onCallBackTriggering(byte callback, ConnectivityMessage message);
}
