package uicc.hci.services.connectivity;

import uicc.hci.framework.*;

/**
 * The connectivity services defines:
 * <ul>
 * <li> a mechanism that allows a UICC to start a proactive session as defined
 * in TS 102 223,
 * 
 * <li> a mechanism to launch an application on the terminal host that
 * is related to the Applet running in the UICC.
 * </ul>
 * 
 **/
public interface ConnectivityService extends HCIService {

    /**
     * This non-blocking method builds the HCI event EVT_CONNECTIVITY which notifies
     * the terminal host that it shall send a "HCI connectivity event"
     * as defined in TS 102 223.
     * @throws HCIException with the following reason code:
     *                      <ul>
     *                          <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled
     *                          <li><code>HCI_RESOURCES_NOT_AVAILABLE</code> if the contactless framework does not have enough resources to process the command
     *                          <li><code> HCI_CONDITIONS_NOT_SATISFIED</code> if the conditions to call this method are not satisfied
     *                      </ul>
     */
    public void prepareAndSendConnectivityEvent() throws HCIException;

    /**
     * This non-blocking method builds the HCI event EVT_TRANSACTION which notifies
     * the terminal host that it shall launch an application on the terminal
     * which is associated to an Applet in the UICC host identified.
     * 
     * @param aid buffer with the AID of the Applet instance
     * @param aidOffset offset in the buffer with the AID
     * @param aidLen AID length
     * @param parameters buffer with the parameters
     * @param parametersOffset offset in the buffer with the parameters
     * @param parametersLen length of the parameters
     * @throws HCIException with the following reason code: 
     *                      <ul>
     *                          <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled
     *                          <li><code>HCI_RESOURCES_NOT_AVAILABLE</code> if the contactless framework does not have enough resources to process the command
     *                          <li><code> HCI_CONDITIONS_NOT_SATISFIED</code> if the conditions to call this method are not satisfied
     *                          <li><code>HCI_INVALID_LENGTH</code> if the parameter length or the AID is not compliant to TS 102 622[4]
     *                      </ul>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     * @exception NullPointerException if <code>parameters</code> is <code>null</code> or <code>aid</code> is <code>null</code>
     */
    public void prepareAndSendTransactionEvent(
            byte[] aid,
            short aidOffset,
            short aidLen,
            byte[] parameters,
            short parametersOffset,
            short parametersLen)  throws HCIException,ArrayIndexOutOfBoundsException,NullPointerException;

    /**
     * This non-blocking method builds the HCI event EVT_TRANSACTION which notifies
     * the terminal host that it shall launch an application on the terminal
     * which is associated to an Applet in the UICC host identified.
     * The Contactless Framework shall add the AID of the calling Applet instance
     * to the HCI event passed to the CLF.
     *
     * @param parameters buffer with the parameters
     * @param parametersOffset offset in the buffer with the parameters
     * @param parametersLen length of the parameters
     * @throws HCIException with the following reason code: 
     *                  <ul> <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled
     *                       <li><code>HCI_RESOURCES_NOT_AVAILABLE</code> if the contactless framework does not have enough resources to process the command
     *                       <li><code> HCI_CONDITIONS_NOT_SATISFIED</code> if the conditions to call this method are not satisfied
     *                       <li><code>HCI_INVALID_LENGTH</code> if the parameter length or the AID is not compliant to TS 102 622[4]
     *                    </ul>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     * @exception NullPointerException if <code>parameters</code> is <code>null</code>
     */
    public void prepareAndSendTransactionEvent(
            byte[] parameters,
            short parametersOffset,
            short parametersLen)  throws HCIException,ArrayIndexOutOfBoundsException,NullPointerException;
}

