/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.CardRuntimeException;

/**
 * The <code>HCIException</code> class encapsulates specific exceptions allows
 * the classes of this package to throw specific exceptions in case of problems. <p>
 **/
public class HCIException extends CardRuntimeException {

    // ---------  Reasons value -------------
    /** The HCI protocol is not available. */
    public final static short HCI_NOT_AVAILABLE = (short)0; 
    /** The Applet is not granted access to this HCI resource*/
    public final static short HCI_ACCESS_NOT_GRANTED = (short)1;
    /** The requested Service (CardEmulation, ReaderMode, Connectivity) is not avilable */
    public final static short HCI_SERVICE_NOT_VAILABLE = (short)2;
    /** The contactless frontend is currently disabled */
    public final static short HCI_CURRENTLY_DISABLED = (short)3;
    /** Inidictates that a wrong Listener type is registered to a Service */
    public final static short HCI_WRONG_LISTENER_TYPE = (short)4;
     /** Inidictates that an Applet instance ahas already registerd a Listener of this type */
    public final static short HCI_LISTENER_ALLREADY_REGISTERED = (short)5;
    /** Inidictates that a wrong event type is activated for this Service */
    public final static short HCI_WRONG_EVENT_TYPE = (short)6;
    
    /**
     * Constructs a HCIException with the specified reason. To conserve on resources use
     * <code>throwIt()</code> to use the JCRE instance of this class.
     *
     * @param  reason the reason for the exception
     */
    public HCIException(short reason) {
        super(reason);
    }

    /**
     * Throws the JCRE owned instance of the <code>HCIException</code> with the specified
     * reason code.
     * 
     * @param reason the reason for the exception.
     * @exception HCIException
     */
    public static void throwIt(short reason) throws HCIException {
    }
}

