/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.*;

/**
 * This class provides a factory to retrieve objects instances that implement sub
 * interfaces of <code>HCIService</code> and a method to check it certain features
 * are supported by the UII or the terminal.
 *
 **/
public final class HCIDevice {

    /** Identifies the service object for reader mode functionality */
    public final static short READER_SERVICE_ID = (short)2;
   
    /** Identifies the service object for card emulation mode functionality */
    public static final short CARD_EMULATION_SERVICE_ID = (short)3;
    
    /** Identifies the service object for connectivity functionality */
    public final static short CONNECTIVITY_SERVICE_ID = (short)4;

    /**Identifies the feature of automated sending of the proactive command ACTIVATE */
    public final static short AUTO_ACTIVATE_SERVICE_ID = (short)5;

    /** UICC is activated in low power mode */
    public final static byte LOW_POWER_MODE = (byte)0x00;
    
    /** UICC is activated in full power mode */
    public final static byte FULL_POWER_MODE = (byte)0x01;
    

    /**
     * private constructor
     **/
    private HCIDevice() {
    }


    /**
     * This method is used to retrieve an instances that implement one of <code>HCIService</code>
     * subinterfaces defined in this specification.
     * <P>
     * This method returns <code>null</code> if the <code>Applet.register()</code> method has not yet
     * been invoked.
     *  <p>
     * If the Applet instance invoking this method passes <code>CARD_EMULATION_SERVICE_ID</code> as
     * parameter, and the the Communication Interface Access Configuration of this Applet instance does not
     * allow "Proximity based communication" according to clause 5 of GlobaPlatform Card Specification Amendment [8],
     * a <code>HCIExceptions</code> with reason code <code>HCI_ACCESS_NOT_GRANTED</code> shall be thrown.
     * <p>
     * If no "Parameters for contactless applications" as defined in ETSI TS 102 226 [7] have been assigned to the
     * Applet instance invoking this method and passing <code>READER_SERVICE_ID</code> as parameter, a
     * <code>HCIException</code> with reason code <code>HCI_ACCES_NOT_GRANTED</code> shall be thrown.
     *
     * @param serviceID shall be one of the constants (*)_SERVICE_ID defined 
     * in this class.
     * @return reference to the permanent JCRE entry point object of the <code>HCIService</code> or
     *         <code>null</code> if not yet registered.
     * @throws HCIException with reason:
     * <ul>
     * <li>HCI_ACCESS_NOT_GRANTED if access to the indicated service is
     * not permitted for the Applet
     * <li>HCI_SERVICE_NOT_AVAILABLE if the requested service type is not available
     * </ul>
     * @exception SystemException with the following reason code: <ul>
     *      <li><code>ILLEGAL_VALUE</code> <ul><li>if the serviceID does not match with the predefined values</li></ul>
     *
     */
    public static HCIService getHCIService(short serviceID) throws HCIException, SystemException {
        return null;
    }

    /**
     * This method returns the current power mode of the UICC as defined in TS 102 613.
     * Possible values are:
     * <ul>
     * <li>LOW_POWER_MODE</li>
     * <li>FULL_POWER_MODE</li>
     * </ul>
     * @return the current power mode or -1 if the power mode can not be retrieved
     */
    public static byte getPowerMode() { return (byte)-1; }


    /**
     * This method is used to retrieve information about the availability of a HCIService
     * or about the availability of a feature of the contacless framework.
     *
     * <p>
     * If the Applet instance invoking this method passes <code>CARD_EMULATION_SERVICE_ID</code> as
     * parameter and the the Communication Interface Access Configuration of this Applet instance does not
     * allow "Proximity based communication" according to clause 5 of GlobaPlatform Card Specification Amendment [8],
     * a, the return value shall indicate "access not allowed for Applet".
     * <p>
     * If no "Parameters for contactless applications" as defined in ETSI TS 102 226 [7] have been assigned to the
     * Applet instance invoking this method and passing <code>READER_SERVICE_ID</code> as parameter the return value
     * shall indicate "access not allowed for Applet".
     *
     * @param serviceID shall be one of the constants (*)_SERVICE_ID defined in this class
     * @return byte with the bit values set according to the following list:
     *              <ul>
     *              <li> bit 0 set to 1: SWP/HCI interface not supported by terminal
     *              <li> bit 1 set to 1: requested service not supported by terminal
     *              <li> bit 2 set to 1: access not allowed for Applet
     *              <li> bit 3 set to 1: HCI interface currently disabled in UICC
     *              <li> bit 4 set to 1: service not supported in the UICC
     *              <li> bit 5 set to 0: (RFU)
     *              <li> bit 6 set to 0: (RFU)
     *              <li> bit 7 set to 0: (RFU)
     *              </ul>
     * @throws HCIException with reason:
     * <ul>
     * <li><code>HCI_SERVICE_NOT_AVAILABLE</code> if the requested service type of feature is not know to the contactless runtime environment
     * </ul>
     */
    public static byte isHCIServiceAvailable(short serviceID) throws HCIException { return 0x00; }
}

