/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIService;

/** 
 * Service which provides Contactless card emulation functionality.
 **/
public interface CardEmulationService extends HCIService {

    
    // ------------ card RF type --------------------
    /** Type B reader RF */
    public final static byte TYPE_B_CARD_RF = (byte) 0x21;
    /** Type B' reader RF */
    public final static byte TYPE_B_PRIM_CARD_RF = (byte) 0x22;
    /** Type A reader RF */
    public final static byte TYPE_A_CARD_RF = (byte) 0x23;
    /** Type F card RF */
    public final static byte TYPE_F_CARD_RF = (byte) 0x24;

    /** Gives the card RF type on which the service is connected.
     *
     * @return the reader RF type on which the service is connected, shall be one
     *         of the TYPE_* constant values defined in this interface.
     */
    public byte getCardRFType();
}
