package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIListener;

/**
 * An instance implementing CardEmulationListener is used by an Applet
 * to monitor the ContactlessCardEmulationService.
 *
 * An Object implementing this Listener Interface will onyl receive the events
 * defined in this interface.
 * 
 * @see ContactlessCardEmulationService
 **/
public interface CardEmulationListener extends HCIListener {

    /** This value is used to notify the Applet when a response to the 
     * {@link CardEmulationMessage#prepareAndSendGetParameterCommmand(byte)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     *
     * this is duplicating the the same event in RederListener is maybe better to have one interface that defines all event values
     * */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /** This value is used to notify the Applet when the HCI event EVT_SEND_DATA
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_ON_SEND_DATA = (byte) 0x50;

    /** This value is used to notify the Applet when the HCI event EVT_FIELD_ON
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    /* will go away ??? */
    public final static byte EVENT_FIELD_ON = (byte) 0x51;

    /** This value is used to notify the Applet when the HCI event EVT_FIELD_OFF
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_FIELD_OFF = (byte) 0x54;

   /** This value is used to trigger the Applet when the HCI event EVT_CARD_DEACTIVATED
    * is received.
    * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
    * */
    public final static byte EVENT_CARD_DEACTIVATED = (byte) 0x52;

   /** This value is used to trigger the Applet when the HCI event EVT_CARD_ACTIVATED
    * is received.
    * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
    */
    //public final static byte EVENT_CARD_ACTIVATED = (byte) 0x53;
    // check in comments for other methods
}

