/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.Shareable;

/** The base interface for all types of HCI listeners.
 * <P>
 * An Object shall not implement this interface but only implement one of the subinterfaces.
 *
 * @see uicc.hci.services.cardemulation.CardEmulationListener
 * @see uicc.hci.services.connectivity.ConnectivityListener
 * @see uicc.hci.services.readermode.ReaderListener
 * <P>
 * An Applet instance implementing the <code>*Listener</code> interface shall only receive events defined in the same <code>*Listener</code> interface.
 * <P>
 * Messages received through the inherited method <code>HCIListener</code> shall be the message type defined in the same package as the <code>*Listener</code> interface
 * <P>
 *
 **/
public interface HCIListener extends Shareable {


    /** This method is called by the HCI framework to inform the Listener
     *  Object about a specific event and pass the corresponding <code>HCIMessage</code> to
     *  the Listener Object.
     *  
     * 
     * @param  event that triggers the invocation of the method
     * @param  message the HCIMessage
     */
    public void onCallback(byte event, HCIMessage message);
}
