/*
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.javacard.clientsamples.transit;

/**
 * The constants used by the POS and transit terminal applications.
 * 
 * Note: this interface could also be used by the transit applet itself.
 */
public interface Constants {

    /**
     * CLA value for ISO 7816-4 commands
     */
    byte CLA_ISO7816 = (byte) 0x00;

    /**
     * CLA value for transit-applet-specific commands
     */
    byte TRANSIT_CLA = (byte) 0x80;

    // Codes of INS byte in the command APDU header

    /**
     * INS value for ISO 7816-4 VERIFY command
     */
    byte INS_VERIFY = (byte) 0x20;

    /**
     * INS value for ISO 7816-4 SELECT command
     */
    byte INS_SELECT = (byte) 0XA4;

    /**
     * INS value for INITIALIZE_SESSION command
     */
    byte INITIALIZE_SESSION = (byte) 0x30;

    /**
     * INS value for PROCESS_REQUEST command
     */
    byte PROCESS_REQUEST = (byte) 0x40;

    // Tags for TLV records in PROCESS_REQUEST C-APDU

    /**
     * TLV Tag for PROCESS_ENTRY request
     */
    byte PROCESS_ENTRY = (byte) 0xC1;

    /**
     * TLV Tag for PROCESS_EXIT request
     */
    byte PROCESS_EXIT = (byte) 0xC2;

    /**
     * TLV Tag for CREDIT request
     */
    byte CREDIT = (byte) 0xC3;

    /**
     * TLV Tag for GET_BALANCE request
     */
    byte GET_BALANCE = (byte) 0xC4;

    /**
     * SW bytes for success
     */
    int SW_NO_ERROR = (int) 0x9000;

    /**
     * Unique ID length
     */
    short UID_LENGTH = (short) 8;

    /**
     * Host and card challenge length
     */
    short CHALLENGE_LENGTH = (short) 4;

    /**
     * MAC length as generated by Signature.ALG_DES_MAC8_ISO9797_M2
     */
    short MAC_LENGTH = (short) 8;

    /**
     * DES key length in bytes
     */
    int LENGTH_DES_BYTE = 8;

    /**
     * The default host name where the cref or jcwde tool is running
     */
    String DEFAULT_HOST_NAME = "localhost";

    /**
     * The default port the cref or jcwde tool is listening on
     */
    int DEFAULT_PORT = 9025;

    /**
     * The AID for the transit applet
     */
    byte[] AID_TRANSIT = { (byte) 0xa0, (byte) 0x0, (byte) 0x0, (byte) 0x0,
            (byte) 0x62, (byte) 0x3, (byte) 0x1, (byte) 0xc, (byte) 0xD,
            (byte) 0x1 };

}
